/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.ui.CompareResultDialog;
import org.eclipse.dltk.internal.testing.ui.FailureTrace;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class CompareResultsAction
extends Action {
    private FailureTrace fView;
    private CompareResultDialog fOpenDialog;

    public CompareResultsAction(FailureTrace view) {
        super(DLTKTestingMessages.CompareResultsAction_label);
        this.setDescription(DLTKTestingMessages.CompareResultsAction_description);
        this.setToolTipText(DLTKTestingMessages.CompareResultsAction_tooltip);
        this.setDisabledImageDescriptor(DLTKTestingPlugin.getImageDescriptor("dlcl16/compare.gif"));
        this.setHoverImageDescriptor(DLTKTestingPlugin.getImageDescriptor("elcl16/compare.gif"));
        this.setImageDescriptor(DLTKTestingPlugin.getImageDescriptor("elcl16/compare.gif"));
        this.fView = view;
    }

    public void run() {
        TestElement failedTest = this.fView.getFailedTest();
        if (this.fOpenDialog != null) {
            this.fOpenDialog.setInput(failedTest);
            this.fOpenDialog.getShell().setActive();
        } else {
            this.fOpenDialog = new CompareResultDialog(this.fView.getShell(), failedTest);
            this.fOpenDialog.create();
            this.fOpenDialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CompareResultsAction.this.fOpenDialog = null;
                }
            });
            this.fOpenDialog.setBlockOnOpen(false);
            this.fOpenDialog.open();
        }
    }

    public void updateOpenDialog(TestElement failedTest) {
        if (this.fOpenDialog != null) {
            this.fOpenDialog.setInput(failedTest);
        }
    }
}

