/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.folding;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.javascript.ast.AbstractNavigationVisitor;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.IVariableStatement;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.internal.ui.text.folding.JavaScriptFoldingBlockKind;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockKind;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingBlockRequestor;
import org.eclipse.dltk.ui.text.folding.IFoldingContent;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptCodeFoldingBlockProvider
extends AbstractNavigationVisitor<Object>
implements IFoldingBlockProvider {
    private boolean collapseMethods;
    private boolean collapseObjectInitializers;
    private boolean collapseXml;
    private boolean collapseStrings;
    private int fBlockLinesMin;
    private IFoldingBlockRequestor requestor;
    private MethodCollector methodCollector = new MethodCollector();
    private final Map<String, Scope> names = new HashMap<String, Scope>();

    private static Script parse(IFoldingContent content) {
        IModuleDeclaration declaration;
        if (content.getModelElement() instanceof ISourceModule && (declaration = SourceParserUtil.parse((ISourceModule)((ISourceModule)content.getModelElement()), null)) instanceof Script) {
            return (Script)declaration;
        }
        JavaScriptParser parser = new JavaScriptParser();
        return parser.parse((IModuleSource)content, null);
    }

    public void initializePreferences(IPreferenceStore preferenceStore) {
        this.collapseMethods = preferenceStore.getBoolean("editor_folding_init_methods");
        this.fBlockLinesMin = preferenceStore.getInt("editor_folding_lines_limit");
    }

    public int getMinimalLineCount() {
        return this.fBlockLinesMin;
    }

    public void setRequestor(IFoldingBlockRequestor requestor) {
        this.requestor = requestor;
    }

    public void computeFoldableBlocks(IFoldingContent content) {
        this.names.clear();
        Script script = JavaScriptCodeFoldingBlockProvider.parse(content);
        if (script != null) {
            block3: {
                this.methodCollector.clear();
                try {
                    content.getModelElement().accept((IModelElementVisitor)this.methodCollector);
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
            this.visitScript(script);
            this.names.clear();
        }
    }

    public Object visitFunctionStatement(FunctionStatement node) {
        IModelElement element = null;
        Identifier name = node.getName();
        if (name != null) {
            element = this.methodCollector.get(name.sourceStart(), name.sourceEnd() - name.sourceStart());
        }
        this.requestor.acceptBlock(node.sourceStart(), node.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.FUNCTION, (Object)element, this.collapseMethods);
        return super.visitFunctionStatement(node);
    }

    protected Object visitMethod(Method method) {
        this.requestor.acceptBlock(method.sourceStart(), method.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.FUNCTION, null, this.collapseMethods);
        return super.visitMethod(method);
    }

    public Object visitObjectInitializer(ObjectInitializer node) {
        Key assignemtKey;
        if (node.isMultiline() && (assignemtKey = this.getAssignementKey(node.getParent())) != null) {
            this.requestor.acceptBlock(node.sourceStart(), node.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.OBJECT_INITIALIZER, (Object)assignemtKey, this.collapseObjectInitializers);
        }
        return super.visitObjectInitializer(node);
    }

    private Key getAssignementKey(ASTNode node) {
        String path;
        BinaryOperation operation;
        if (node instanceof VariableDeclaration) {
            VariableDeclaration declaration = (VariableDeclaration)node;
            IVariableStatement statement = (IVariableStatement)declaration.getParent();
            if (statement.getVariables().size() == 1) {
                return this.registerName(declaration.getVariableName(), (ASTNode)declaration.getIdentifier());
            }
        } else if (node instanceof BinaryOperation && (operation = (BinaryOperation)node).getOperation() == 104 && (path = PropertyExpressionUtils.getPath((Expression)operation.getLeftExpression())) != null) {
            return this.registerName(path, (ASTNode)operation.getLeftExpression());
        }
        return null;
    }

    public Object visitBinaryOperation(BinaryOperation node) {
        Expression expression;
        String name;
        if (node.getOperation() == 104 && (name = PropertyExpressionUtils.getPath((Expression)(expression = node.getLeftExpression()))) != null) {
            this.registerName(name, (ASTNode)expression);
        }
        return super.visitBinaryOperation(node);
    }

    public Object visitVariableStatement(VariableStatement node) {
        for (VariableDeclaration declaration : node.getVariables()) {
            this.registerName(declaration.getVariableName(), (ASTNode)declaration);
        }
        return super.visitVariableStatement(node);
    }

    private Key registerName(String name, ASTNode node) {
        Scope scope = this.names.get(name);
        if (scope == null) {
            scope = new Scope(name);
            this.names.put(name, scope);
        }
        return scope.getKey(node);
    }

    public Object visitXmlLiteral(XmlLiteral node) {
        this.requestor.acceptBlock(node.sourceStart(), node.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.XML, null, this.collapseXml);
        return super.visitXmlLiteral(node);
    }

    public Object visitStringLiteral(StringLiteral node) {
        this.requestor.acceptBlock(node.sourceStart(), node.sourceEnd(), (IFoldingBlockKind)JavaScriptFoldingBlockKind.MULTILINESTRING, null, this.collapseStrings);
        return super.visitStringLiteral(node);
    }

    static class Key {
        final String name;
        final int occurence;

        public Key(String name, int occurence) {
            this.name = name;
            this.occurence = occurence;
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.occurence;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.occurence == other.occurence && this.name.equals(other.name);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodCollector
    extends HashMap<ISourceRange, IModelElement>
    implements IModelElementVisitor {
        public boolean visit(IModelElement element) {
            if (element instanceof IMethod) {
                try {
                    this.put(new SourceRange(((IMethod)element).getNameRange()), element);
                }
                catch (ModelException modelException) {}
            }
            return true;
        }

        public IModelElement get(int offset, int length) {
            return (IModelElement)this.get(new SourceRange(offset, length));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Scope
    extends IdentityHashMap<ASTNode, Key> {
        final String name;
        private int lastValue;

        public Scope(String name) {
            this.name = name;
        }

        Key getKey(ASTNode node) {
            Key key = (Key)this.get(node);
            if (key == null) {
                key = new Key(this.name, this.lastValue++);
                this.put(node, key);
            }
            return key;
        }
    }
}

