/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.internal.javascript.parser.structure.Declaration;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureReporter;
import org.eclipse.dltk.internal.javascript.ti.IReferenceAttributes;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;

class MethodDeclaration
extends Declaration
implements IReferenceAttributes {
    public MethodDeclaration(String childName, IValueReference child) {
        super(childName, child);
    }

    public void report(StructureReporter reporter, boolean allowFields) {
        ReferenceLocation location = this.child.getLocation();
        reporter.removeReference(this.childName, location.getNameStart(), location.getNameEnd());
        reporter.reportRefs(location.getDeclarationStart());
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.name = this.childName;
        mi.returnType = MethodDeclaration.extractType(this.child.getChild("()"));
        MethodDeclaration.copyLocation(location, (IElementRequestor.ElementInfo)mi);
        IModelBuilder.IMethod method = (IModelBuilder.IMethod)this.child.getAttribute("METHOD");
        if (method != null) {
            if (mi.returnType == null) {
                mi.returnType = TypeUtil.getName(method.getType());
            }
            if (method.isDeprecated()) {
                mi.modifiers |= 0x40000;
            }
            List<IModelBuilder.IParameter> parameters = method.getParameters();
            for (IModelBuilder.IParameter parameter : parameters) {
                if (parameter.getType() == null) continue;
                mi.parameterTypes = new String[method.getParameterCount()];
                break;
            }
            mi.parameterNames = new String[method.getParameterCount()];
            int i = 0;
            while (i < parameters.size()) {
                IModelBuilder.IParameter parameter = parameters.get(i);
                mi.parameterNames[i] = parameter.getName();
                if (mi.parameterTypes != null) {
                    mi.parameterTypes[i] = TypeUtil.getName(parameter.getType());
                }
                ++i;
            }
        }
        reporter.fRequestor.enterMethod(mi);
        IValueCollection functionScope = (IValueCollection)this.child.getAttribute("FUNCTION_SCOPE");
        if (functionScope != null) {
            reporter.processScope(functionScope, false);
        }
        reporter.reportRefs(location.getDeclarationEnd());
        reporter.fRequestor.exitMethod(location.getDeclarationEnd());
    }
}

