/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParserBase;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParserExtension;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.RecordProperty;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocTypeParser
extends JSDocTypeParserBase {
    public static final String FUNCTION = "function";
    public static final String CLASS = "Class";
    private JSDocTypeParserExtension extension;

    public void setExtension(JSDocTypeParserExtension extension) {
        this.extension = extension;
    }

    public JSType parse(String input) throws ParseException {
        return this.parse((CharStream)new ANTLRStringStream(input));
    }

    protected JSType parse(CharStream input) throws ParseException {
        JSType type;
        boolean inParenthese;
        this.skipSpaces(input);
        ArrayList<JSType> types = new ArrayList<JSType>();
        boolean bl = inParenthese = input.LT(1) == 40;
        if (inParenthese) {
            input.consume();
        }
        while ((type = this.parseType(input)) != null) {
            types.add(type);
            this.skipSpaces(input);
            if (input.LT(1) != 124) break;
            input.consume();
        }
        if (inParenthese) {
            this.match(input, ')');
        }
        if (types.size() == 1) {
            return (JSType)types.get(0);
        }
        if (types.size() > 1) {
            UnionType unionType = TypeInfoModelFactory.eINSTANCE.createUnionType();
            unionType.getTargets().addAll(types);
            return unionType;
        }
        return null;
    }

    protected JSType parseType(CharStream input) throws ParseException {
        if (input.LT(1) == 63) {
            input.consume();
        } else if (input.LT(1) == 33) {
            input.consume();
        }
        if (input.LT(1) == 123) {
            input.consume();
            RecordType recordType = this.parseRecordType(input);
            this.match(input, '}');
            return recordType;
        }
        if (input.LT(1) == 42) {
            input.consume();
            return TypeInfoModelFactory.eINSTANCE.createAnyType();
        }
        return this.parseTypeName(input);
    }

    protected JSType parseTypeName(CharStream input) throws ParseException {
        int start = input.index();
        while (true) {
            int ch;
            if ((ch = input.LT(1)) == 60) {
                int baseEnd = input.index();
                String baseType = input.substring(start, baseEnd - 1);
                input.consume();
                List<JSType> typeParams = this.parseParams(input);
                this.match(input, '>');
                JSType type = this.createGenericType(baseType, typeParams);
                if (this.extension != null) {
                    this.extension.reportType(type, start, baseEnd);
                }
                return this.checkIfArray(input, type);
            }
            if (ch == 46 && input.LT(2) == 60) {
                int baseEnd = input.index();
                String baseType = input.substring(start, baseEnd - 1);
                input.consume();
                input.consume();
                List<JSType> typeParams = this.parseParams(input);
                this.match(input, '>');
                JSType type = this.createGenericType(baseType, typeParams);
                if (this.extension != null) {
                    this.extension.reportType(type, start, baseEnd);
                }
                return this.checkIfArray(input, type);
            }
            if (ch == 40 && FUNCTION.equals(input.substring(start, input.index() - 1))) {
                input.consume();
                FunctionType functionType = TypeInfoModelFactory.eINSTANCE.createFunctionType();
                this.parseFunctionParams(input, functionType.getParameters());
                this.match(input, ')');
                this.skipSpaces(input);
                if (input.LT(1) == 58) {
                    input.consume();
                    this.skipSpaces(input);
                    functionType.setReturnType(this.parseType(input));
                }
                return this.checkIfArray(input, functionType);
            }
            if (ch == 91) {
                JSType itemType = this.createType(input, start);
                input.consume();
                this.match(input, ']');
                JSType array = this.createArray(itemType);
                return this.checkIfArray(input, array);
            }
            if (ch == -1 || Character.isWhitespace(ch) || ch == 124 || ch == 44 || ch == 61 || ch == 125 || ch == 62 || ch == 41 || ch == 93) {
                return input.index() > start ? this.createType(input, start) : null;
            }
            input.consume();
        }
    }

    private JSType createType(CharStream input, int start) {
        int end = input.index();
        JSType type = this.createType(this.translate(input.substring(start, end - 1)));
        if (this.extension != null) {
            this.extension.reportType(type, start, end);
        }
        return type;
    }

    private JSType checkIfArray(CharStream input, JSType type) throws ParseException {
        int ch = input.LT(1);
        while (ch == 91) {
            input.consume();
            this.match(input, ']');
            type = this.createArray(type);
            ch = input.LT(1);
        }
        return type;
    }

    protected JSType createType(String typeName) {
        if ("undefined".equals(typeName)) {
            return TypeInfoModelFactory.eINSTANCE.createUndefinedType();
        }
        if (CLASS.equals(typeName)) {
            return TypeInfoModelFactory.eINSTANCE.createClassType();
        }
        return TypeUtil.ref(typeName);
    }

    protected JSType createArray(JSType itemType) {
        return TypeUtil.arrayOf(itemType);
    }

    protected JSType createGenericType(String baseType, List<JSType> typeParams) {
        if ("Array".equals(baseType)) {
            if (typeParams.size() >= 1) {
                return this.createArray(typeParams.get(0));
            }
            return this.createArray(this.createType("Object"));
        }
        if (CLASS.equals(baseType) && typeParams.size() >= 1) {
            JSType typeParam = typeParams.get(0);
            return TypeUtil.classType(typeParam instanceof SimpleType ? ((SimpleType)typeParam).getTarget() : null);
        }
        if ("Object".equals(baseType)) {
            if (typeParams.size() == 1) {
                return TypeUtil.mapOf(null, typeParams.get(0));
            }
            if (typeParams.size() >= 2) {
                return TypeUtil.mapOf(typeParams.get(0), typeParams.get(1));
            }
            return TypeUtil.mapOf(null, "Object");
        }
        return this.doCreateGenericType(baseType, typeParams);
    }

    protected JSType doCreateGenericType(String baseType, List<JSType> typeParams) {
        if (!typeParams.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(baseType);
            sb.append('<');
            int index = 0;
            for (JSType typeParam : typeParams) {
                if (++index > 1) {
                    sb.append(',');
                }
                sb.append(typeParam.getName());
            }
            sb.append('>');
            return TypeUtil.ref(sb.toString());
        }
        return TypeUtil.ref(baseType);
    }

    protected List<JSType> parseParams(CharStream input) throws ParseException {
        JSType type;
        ArrayList<JSType> types = new ArrayList<JSType>();
        while ((type = this.parse(input)) != null) {
            types.add(type);
            this.skipSpaces(input);
            if (input.LT(1) != 44) break;
            input.consume();
        }
        return types;
    }

    public void parseFunctionParams(CharStream input, EList<Parameter> parameters) throws ParseException {
        while (true) {
            JSType type;
            this.skipSpaces(input);
            boolean varargs = false;
            boolean squareBracket = false;
            if (input.LT(1) == 46 && input.LT(2) == 46 && input.LT(3) == 46) {
                input.consume();
                input.consume();
                input.consume();
                varargs = true;
                if (input.LT(1) == 91) {
                    input.consume();
                    squareBracket = true;
                }
            }
            if ((type = this.parse(input)) == null) break;
            Parameter parameter = TypeInfoModelFactory.eINSTANCE.createParameter();
            parameter.setType(type);
            if (varargs) {
                parameter.setKind(ParameterKind.VARARGS);
                if (squareBracket) {
                    this.match(input, ']');
                }
            } else if (input.LT(1) == 61) {
                parameter.setKind(ParameterKind.OPTIONAL);
                input.consume();
            }
            parameters.add((Object)parameter);
            this.skipSpaces(input);
            if (input.LT(1) != 44) break;
            input.consume();
        }
    }

    protected RecordType parseRecordType(CharStream input) throws ParseException {
        int start = input.index();
        RecordType type = TypeInfoModelFactory.eINSTANCE.createRecordType();
        this.skipSpaces(input);
        while (true) {
            int ch;
            boolean optional;
            boolean bl = optional = (ch = input.LT(1)) == 91;
            if (optional) {
                input.consume();
                ch = input.LT(1);
            }
            boolean validPropertyName = true;
            int nameStart = input.index();
            String name = null;
            if (ch == 34 || ch == 39) {
                input.consume();
                ch = input.LT(1);
                while (ch != 34 && ch != 39 && ch != -1) {
                    input.consume();
                    ch = input.LT(1);
                }
                if (ch == -1) {
                    throw new ParseException("Ending quote expected", input.index());
                }
                validPropertyName = false;
                name = input.substring(nameStart + 1, input.index() - 1);
                input.consume();
            } else if (Character.isJavaIdentifierStart(ch)) {
                input.consume();
                while (Character.isJavaIdentifierPart(input.LT(1))) {
                    input.consume();
                }
                name = input.substring(nameStart, input.index() - 1);
            }
            if (name == null) break;
            RecordProperty property = TypeInfoModelFactory.eINSTANCE.createRecordProperty();
            property.setName(name);
            this.skipSpaces(input);
            if (optional) {
                input.consume();
                property.setOptional(true);
            }
            if (input.LT(1) == 58) {
                input.consume();
                JSType memberType = this.parse(input);
                ch = input.LT(1);
                if (ch == 61) {
                    input.consume();
                    property.setOptional(true);
                }
                if (memberType != null) {
                    property.setType(memberType);
                } else {
                    property.setType(TypeInfoModelFactory.eINSTANCE.createAnyType());
                }
            } else {
                property.setType(TypeInfoModelFactory.eINSTANCE.createAnyType());
            }
            if (validPropertyName) {
                type.getMembers().add((Object)property);
            }
            this.skipSpaces(input);
            if (input.LT(1) != 44) break;
            input.consume();
        }
        type.setTypeName(String.valueOf('{') + input.substring(start, input.index() - 1) + '}');
        return type;
    }

    protected String translate(String typeName) {
        return TypeInfoModelLoader.getInstance().translateTypeName(typeName);
    }
}

