/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching.model;

import java.io.File;
import java.io.IOException;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.Predicate;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.model.InterpreterInfo;
import org.eclipse.dltk.launching.model.LaunchingModelFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchingModel {
    private static LaunchingModel instance = null;
    private Model model = null;
    private final Object modelLock = new Object();
    private static final String MODEL_FILENAME = "model.xmi";

    public static synchronized LaunchingModel getInstance() {
        if (instance == null) {
            instance = new LaunchingModel();
        }
        return instance;
    }

    private LaunchingModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getModel() {
        Object object = this.modelLock;
        synchronized (object) {
            if (this.model == null) {
                this.model = this.loadModel();
                this.model.resource.eAdapters().add((Object)new ModelApapter());
            }
            return this.model;
        }
    }

    private static URI getModelLocation() {
        IPath path = DLTKLaunchingPlugin.getDefault().getStateLocation().append(MODEL_FILENAME);
        return URI.createFileURI((String)path.toOSString());
    }

    private static boolean canLoad(URI location) {
        if (location.isFile()) {
            return new File(location.toFileString()).exists();
        }
        return true;
    }

    private Model loadModel() {
        URI location = LaunchingModel.getModelLocation();
        XMIResourceImpl resource = new XMIResourceImpl(location);
        try {
            if (LaunchingModel.canLoad(location)) {
                resource.load(null);
            }
        }
        catch (IOException e) {
            DLTKLaunchingPlugin.log(e);
        }
        return new Model((Resource)resource);
    }

    public EObject find(IInterpreterInstall interpreter, Predicate<EObject> predicate) {
        InterpreterInfo info = this.getModel().find(interpreter);
        if (info != null) {
            for (EObject object : info.getContents()) {
                if (!predicate.evaluate((Object)object)) continue;
                return object;
            }
        }
        return null;
    }

    public EObject save(IInterpreterInstall interpreter, Predicate<EObject> predicate, EObject value) {
        if (value != null) {
            Assert.isLegal((boolean)predicate.evaluate((Object)value));
        }
        Model model = this.loadModel();
        InterpreterInfo info = model.create(interpreter);
        ListIterator i = info.getContents().listIterator();
        while (i.hasNext()) {
            EObject object = (EObject)i.next();
            if (!predicate.evaluate((Object)object)) continue;
            if (value != null) {
                i.set(value);
            } else {
                i.remove();
            }
            model.save();
            return object;
        }
        if (value != null) {
            info.getContents().add((Object)value);
            model.save();
        }
        return null;
    }

    private class Model {
        final Resource resource;

        public Model(Resource resource) {
            this.resource = resource;
        }

        public InterpreterInfo find(IInterpreterInstall interpreter) {
            String environmentId = interpreter.getEnvironmentId();
            String location = interpreter.getInstallLocation().getPath().toString();
            for (EObject object : this.resource.getContents()) {
                InterpreterInfo info;
                if (!(object instanceof InterpreterInfo) || !environmentId.equals((info = (InterpreterInfo)object).getEnvironment()) || !location.equals(info.getLocation())) continue;
                return info;
            }
            return null;
        }

        public InterpreterInfo create(IInterpreterInstall interpreter) {
            InterpreterInfo info = this.find(interpreter);
            if (info == null) {
                info = LaunchingModelFactory.eINSTANCE.createInterpreterInfo();
                info.setEnvironment(interpreter.getEnvironmentId());
                info.setLocation(interpreter.getInstallLocation().getPath().toString());
                this.resource.getContents().add((Object)info);
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save() {
            try {
                this.resource.save(null);
                Object object = LaunchingModel.this.modelLock;
                synchronized (object) {
                    LaunchingModel.this.model = null;
                }
            }
            catch (IOException e) {
                DLTKLaunchingPlugin.log(e);
            }
        }
    }

    private static class ModelApapter
    extends EContentAdapter {
        private ModelApapter() {
        }

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch()) {
                throw new UnsupportedOperationException();
            }
            super.notifyChanged(notification);
        }
    }
}

