/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.AbstractReference;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;

public class ChildReference
extends AbstractReference {
    private final IValueProvider parent;
    private final String name;

    public ChildReference(IValueProvider parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public boolean isReference() {
        if ("()".equals(this.name) || "[]".equals(this.name)) {
            return false;
        }
        return this.parent.isReference();
    }

    public IValue getValue() {
        if (this.parent instanceof IValueCollection) {
            return ChildReference.findChild((IValueCollection)((Object)this.parent), this.name);
        }
        IValue parentValue = this.parent.getValue();
        if (parentValue != null) {
            return parentValue.getChild(this.name, true);
        }
        return null;
    }

    private static IValue findChild(IValueCollection collection, String name) {
        while (collection != null) {
            IValue childValue;
            if (collection instanceof IValueProvider && (childValue = ((IValueProvider)((Object)collection)).getValue().getChild(name, true)) != null) {
                return childValue;
            }
            collection = collection.getParent();
        }
        return null;
    }

    public IValue createValue() {
        IValue childValue;
        if (this.parent instanceof IValueCollection && (childValue = ChildReference.findChild((IValueCollection)((Object)this.parent), this.name)) != null) {
            return childValue;
        }
        IValue parentValue = this.parent.createValue();
        if (parentValue != null) {
            return parentValue.createChild(this.name, 0);
        }
        return null;
    }

    public IValueReference getParent() {
        if (this.parent instanceof IValueReference) {
            return (IValueReference)((Object)this.parent);
        }
        return null;
    }

    public void delete() {
        IValue value = this.parent.getValue();
        if (value != null) {
            value.deleteChild(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.parent.toString()) + "." + this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChildReference) {
            ChildReference other = (ChildReference)obj;
            return this.name.equals(other.name) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

