/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.parser.JavaScriptParser;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Method;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptValidations {
    static final String ATTR_INCONSISTENT_RETURNS = String.valueOf(JavaScriptValidations.class.getName()) + ".INCONSISTENT_RETURNS";

    public static Script parse(IBuildContext context) {
        IModuleDeclaration declaration;
        IModuleDeclaration savedAST = (IModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (savedAST instanceof Script) {
            return (Script)savedAST;
        }
        ISourceModule module = context.getSourceModule();
        if (module != null && (declaration = SourceParserUtil.parse((ISourceModule)module, (IProblemReporter)context.getProblemReporter())) instanceof Script) {
            context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)declaration);
            return (Script)declaration;
        }
        JavaScriptParser parser = new JavaScriptParser();
        Script script = parser.parse((IModuleSource)context, context.getProblemReporter());
        context.set(IBuildContext.ATTR_MODULE_DECLARATION, (Object)script);
        return script;
    }

    public static IRType typeOf(IValueReference reference) {
        if (reference != null) {
            if (reference.getDeclaredType() != null) {
                return reference.getDeclaredType();
            }
            JSTypeSet declaredTypes = reference.getDeclaredTypes();
            if (declaredTypes.size() == 1) {
                return declaredTypes.getFirst();
            }
            JSTypeSet types = reference.getTypes();
            if (types.size() == 1) {
                return types.getFirst();
            }
        }
        return null;
    }

    public static JSTypeSet getTypes(IValueReference reference) {
        if (reference != null) {
            JSTypeSet set = JSTypeSet.create();
            if (reference.getDeclaredType() != null) {
                set.add(reference.getDeclaredType());
            }
            JSTypeSet declaredTypes = reference.getDeclaredTypes();
            set.addAll(declaredTypes);
            JSTypeSet types = reference.getTypes();
            set.addAll(types);
            return set;
        }
        return JSTypeSet.emptySet();
    }

    protected static Reporter createReporter(IBuildContext context) {
        return new Reporter(context.getLineTracker(), context.getProblemReporter());
    }

    private static <E extends Member> boolean canConvert(Object value, Class<E> elementType) {
        return elementType.isInstance(value) || elementType == Method.class && value instanceof Type && ((Type)value).getStaticConstructor() != null;
    }

    private static <E extends Member> E convert(Object value, Class<E> elementType) {
        if (elementType.isInstance(value)) {
            return (E)((Member)value);
        }
        return (E)((Type)value).getStaticConstructor();
    }

    public static <E extends Member> List<E> extractElements(IValueReference reference, Class<E> elementType) {
        Object value = reference.getAttribute("ELEMENT");
        if (JavaScriptValidations.canConvert(value, elementType)) {
            return Collections.singletonList(JavaScriptValidations.convert(value, elementType));
        }
        if (value instanceof Object[]) {
            Object[] elements = (Object[])value;
            ArrayList<E> result = null;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (JavaScriptValidations.canConvert(element, elementType)) {
                    if (result == null) {
                        result = new ArrayList<E>(elements.length);
                    }
                    result.add(JavaScriptValidations.convert(element, elementType));
                }
                ++n2;
            }
            return result;
        }
        return null;
    }

    public static <METHOD extends Method> METHOD selectMethod(ITypeSystem context, List<METHOD> methods, IValueReference[] arguments, boolean fallback) {
        if (methods.size() == 1) {
            return (METHOD)((Method)methods.get(0));
        }
        ArrayList<Method> matches = null;
        for (Method method : methods) {
            if (!JavaScriptValidations.checkParameterCount(method, arguments.length)) continue;
            if (matches == null) {
                matches = new ArrayList<Method>(4);
            }
            matches.add(method);
        }
        if (matches != null) {
            if (matches.size() == 1) {
                return (METHOD)((Method)matches.get(0));
            }
            block1: for (Method method : matches) {
                EList<Parameter> parameters = method.getParameters();
                int i = 0;
                while (i < Math.min(parameters.size(), arguments.length)) {
                    IRType argumentType;
                    JSType parameterType = ((Parameter)parameters.get(i)).getType();
                    if (parameterType != null && (argumentType = JavaScriptValidations.typeOf(arguments[i])) != null && JSTypeSet.normalize(context, parameterType).isAssignableFrom(argumentType) == TypeCompatibility.FALSE) continue block1;
                    ++i;
                }
                return (METHOD)method;
            }
        }
        return (METHOD)(fallback ? (Method)methods.get(0) : null);
    }

    @Deprecated
    public static boolean isStatic(IValueReference valueRef) {
        if (valueRef == null) {
            return false;
        }
        for (IRType type : valueRef.getDeclaredTypes()) {
            if (type == null || !(type instanceof IRClassType)) continue;
            return true;
        }
        for (IRType type : valueRef.getTypes()) {
            if (type == null || !(type instanceof IRClassType)) continue;
            return true;
        }
        return false;
    }

    static boolean checkParameterCount(Method method, int argCount) {
        EList<Parameter> params = method.getParameters();
        if (params.size() == argCount) {
            return true;
        }
        if (params.size() < argCount) {
            return !params.isEmpty() && ((Parameter)params.get(params.size() - 1)).getKind() == ParameterKind.VARARGS;
        }
        if (params.size() > argCount) {
            ParameterKind last = ((Parameter)params.get(argCount)).getKind();
            return last == ParameterKind.OPTIONAL || last == ParameterKind.VARARGS;
        }
        return false;
    }
}

