/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;

public class ParenthesizedExpression
extends Expression {
    private Expression expression;
    private int LP = -1;
    private int RP = -1;

    public ParenthesizedExpression(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.expression != null) {
                this.expression.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LP >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RP > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(this.expression.toSourceString(indentationString));
        buffer.append(")");
        return buffer.toString();
    }
}

