/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.List;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RFunctionType
extends RType
implements IRFunctionType {
    private final ITypeSystem typeSystem;
    private final List<IRParameter> parameters;
    private final IRType returnType;

    public RFunctionType(ITypeSystem typeSystem, List<IRParameter> parameters, IRType returnType) {
        this.typeSystem = typeSystem;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    @Override
    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("function");
        sb.append('(');
        int index = 0;
        for (IRParameter parameter : this.parameters) {
            if (++index != 1) {
                sb.append(", ");
            }
            if (parameter.getKind() == ParameterKind.VARARGS) {
                sb.append("...");
            }
            sb.append(parameter.getType());
            if (parameter.getKind() != ParameterKind.OPTIONAL) continue;
            sb.append("=");
        }
        sb.append(')');
        if (this.returnType != null) {
            sb.append(':');
            sb.append(this.returnType);
        }
        return sb.toString();
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof RFunctionType) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof IRSimpleType) {
            return TypeCompatibility.valueOf(Types.FUNCTION == ((IRSimpleType)type).getTarget());
        }
        return TypeCompatibility.FALSE;
    }

    @Override
    public IRType getReturnType() {
        return this.returnType;
    }

    @Override
    public List<IRParameter> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RFunctionType other = (RFunctionType)obj;
        if (!this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }
}

