/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.FormatterSyntaxProblemException;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class FormatterPreviewUtils {
    private static final String LINE_SEPARATOR = "\n";
    private static final String ENCODING = "ISO-8859-1";

    public static void updatePreview(ISourceViewer viewer, URL previewContent, IScriptFormatterFactory factory, Map preferences) {
        if (previewContent != null) {
            String content;
            try {
                String c = new String(Util.getInputStreamAsCharArray((InputStream)previewContent.openConnection().getInputStream(), (int)-1, (String)ENCODING));
                content = Strings.concatenate(TextUtils.splitLines((CharSequence)c), LINE_SEPARATOR);
            }
            catch (IOException e) {
                DLTKUIPlugin.log(e);
                FormatterPreviewUtils.disablePreview(viewer);
                return;
            }
            int tabSize = FormatterPreviewUtils.toInt(preferences.get("formatter.tabulation.size"));
            if (tabSize != viewer.getTextWidget().getTabs()) {
                viewer.getTextWidget().setTabs(tabSize);
            }
            viewer.getTextWidget().setEnabled(true);
            IScriptFormatter formatter = factory.createFormatter(LINE_SEPARATOR, preferences);
            try {
                TextEdit textEdit = formatter.format(content, 0, content.length(), 0);
                if (textEdit != null) {
                    Document document = new Document(content);
                    textEdit.apply((IDocument)document);
                    viewer.getDocument().set(document.get());
                    return;
                }
            }
            catch (BadLocationException e) {
                DLTKUIPlugin.log(e);
            }
            catch (MalformedTreeException e) {
                DLTKUIPlugin.log(e);
            }
            catch (FormatterSyntaxProblemException formatterSyntaxProblemException) {
            }
            catch (FormatterException e) {
                DLTKUIPlugin.log(e);
            }
            viewer.getDocument().set(content);
        } else {
            FormatterPreviewUtils.disablePreview(viewer);
        }
    }

    private static int toInt(Object value) {
        if (value != null) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    private static void disablePreview(ISourceViewer viewer) {
        viewer.getTextWidget().setEnabled(false);
        viewer.getDocument().set("");
    }
}

