/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.ColorPreferenceConverter;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.IColorManagerExtension;
import org.eclipse.dltk.ui.text.ITokenFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptScanner
extends BufferedRuleBasedScanner
implements ITokenFactory {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map<String, Token> fTokenMap = new HashMap<String, Token>();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;
    private String[] fPropertyNamesStrikethrough;
    private String[] fPropertyNamesUnderline;
    private boolean fNeedsLazyColorLoading;

    protected abstract String[] getTokenProperties();

    protected abstract List<IRule> createRules();

    public AbstractScriptScanner(IColorManager manager, IPreferenceStore store) {
        this.fColorManager = manager;
        this.fPreferenceStore = store;
    }

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int length = this.fPropertyNamesColor.length;
        this.fPropertyNamesBold = new String[length];
        this.fPropertyNamesItalic = new String[length];
        this.fPropertyNamesStrikethrough = new String[length];
        this.fPropertyNamesUnderline = new String[length];
        int i = 0;
        while (i < length) {
            this.fPropertyNamesBold[i] = this.getBoldKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesItalic[i] = this.getItalicKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesStrikethrough[i] = this.getStrikethroughKey(this.fPropertyNamesColor[i]);
            this.fPropertyNamesUnderline[i] = this.getUnderlineKey(this.fPropertyNamesColor[i]);
            ++i;
        }
        this.fNeedsLazyColorLoading = Display.getCurrent() == null;
        i = 0;
        while (i < length) {
            this.createToken(i);
            ++i;
        }
        this.initializeRules();
    }

    protected void createToken(int index) {
        if (this.fNeedsLazyColorLoading) {
            this.addTokenWithProxyAttribute(this.fPropertyNamesColor[index], this.fPropertyNamesBold[index], this.fPropertyNamesItalic[index], this.fPropertyNamesStrikethrough[index], this.fPropertyNamesUnderline[index]);
        } else {
            this.addToken(this.fPropertyNamesColor[index], this.fPropertyNamesBold[index], this.fPropertyNamesItalic[index], this.fPropertyNamesStrikethrough[index], this.fPropertyNamesUnderline[index]);
        }
    }

    protected String getBoldKey(String colorKey) {
        return String.valueOf(colorKey) + "_bold";
    }

    protected String getItalicKey(String colorKey) {
        return String.valueOf(colorKey) + "_italic";
    }

    protected String getStrikethroughKey(String colorKey) {
        return String.valueOf(colorKey) + "_strikethrough";
    }

    protected String getUnderlineKey(String colorKey) {
        return String.valueOf(colorKey) + "_underline";
    }

    public IToken nextToken() {
        this.doResolveProxyAttributes();
        return super.nextToken();
    }

    protected final void doResolveProxyAttributes() {
        if (this.fNeedsLazyColorLoading) {
            this.resolveProxyAttributes();
        }
    }

    private void resolveProxyAttributes() {
        if (this.fNeedsLazyColorLoading && Display.getCurrent() != null) {
            int i = 0;
            while (i < this.fPropertyNamesColor.length) {
                this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i], this.fPropertyNamesStrikethrough[i], this.fPropertyNamesUnderline[i]);
                ++i;
            }
            this.fNeedsLazyColorLoading = false;
        }
    }

    private void addTokenWithProxyAttribute(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(null, boldKey, italicKey, strikethroughKey, underlineKey)));
    }

    private void addToken(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        if (this.fColorManager != null && colorKey != null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
        if (!this.fNeedsLazyColorLoading) {
            this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(colorKey, boldKey, italicKey, strikethroughKey, underlineKey)));
        } else {
            Token token = this.fTokenMap.get(colorKey);
            if (token != null) {
                token.setData((Object)this.createTextAttribute(colorKey, boldKey, italicKey, strikethroughKey, underlineKey));
            }
        }
    }

    private TextAttribute createTextAttribute(String colorKey, String boldKey, String italicKey, String strikethroughKey, String underlineKey) {
        int style;
        Color color = null;
        if (colorKey != null) {
            color = this.fColorManager.getColor(colorKey);
        }
        int n = style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
        if (this.fPreferenceStore.getBoolean(italicKey)) {
            style |= 2;
        }
        if (this.fPreferenceStore.getBoolean(strikethroughKey)) {
            style |= 0x20000000;
        }
        if (this.fPreferenceStore.getBoolean(underlineKey)) {
            style |= 0x40000000;
        }
        return new TextAttribute(color, null, style);
    }

    public Token getToken(String key) {
        this.doResolveProxyAttributes();
        Token token = this.fTokenMap.get(key);
        if (token == null) {
            int index = this.fPropertyNamesColor.length;
            this.fPropertyNamesColor = AbstractScriptScanner.resize(this.fPropertyNamesColor, index, key);
            this.fPropertyNamesBold = AbstractScriptScanner.resize(this.fPropertyNamesBold, index, this.getBoldKey(key));
            this.fPropertyNamesItalic = AbstractScriptScanner.resize(this.fPropertyNamesItalic, index, this.getItalicKey(key));
            this.fPropertyNamesStrikethrough = AbstractScriptScanner.resize(this.fPropertyNamesStrikethrough, index, this.getStrikethroughKey(key));
            this.fPropertyNamesUnderline = AbstractScriptScanner.resize(this.fPropertyNamesUnderline, index, this.getUnderlineKey(key));
            this.createToken(index);
            token = this.fTokenMap.get(key);
            Assert.isNotNull((Object)token);
        }
        return token;
    }

    private static String[] resize(String[] old, int index, String value) {
        String[] result = new String[index + 1];
        System.arraycopy(old, 0, result, 0, old.length);
        result[index] = value;
        return result;
    }

    private void initializeRules() {
        List<IRule> rules = this.createRules();
        if (rules != null) {
            this.setRules(rules.toArray(new IRule[rules.size()]));
        }
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.fPropertyNamesColor[i]) || property.equals(this.fPropertyNamesBold[i]) || property.equals(this.fPropertyNamesItalic[i]) || property.equals(this.fPropertyNamesStrikethrough[i]) || property.equals(this.fPropertyNamesUnderline[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        if (index < 0) {
            return;
        }
        Token token = this.getToken(this.fPropertyNamesColor[index]);
        if (this.fPropertyNamesColor[index].equals(p)) {
            this.adaptToColorChange(token, event);
        } else if (this.fPropertyNamesBold[index].equals(p)) {
            this.adaptToStyleChange(token, event, 1);
        } else if (this.fPropertyNamesItalic[index].equals(p)) {
            this.adaptToStyleChange(token, event, 2);
        } else if (this.fPropertyNamesStrikethrough[index].equals(p)) {
            this.adaptToStyleChange(token, event, 0x20000000);
        } else if (this.fPropertyNamesUnderline[index].equals(p)) {
            this.adaptToStyleChange(token, event, 0x40000000);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        RGB rgb = ColorPreferenceConverter.asRGB(event.getNewValue());
        if (rgb != null) {
            Object data;
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            if ((data = token.getData()) instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }
}

