/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.util.Comparator;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionProposalComparator
implements Comparator<ICompletionProposal> {
    private boolean fOrderAlphabetically = false;

    public void setOrderAlphabetically(boolean orderAlphabetically) {
        this.fOrderAlphabetically = orderAlphabetically;
    }

    @Override
    public int compare(ICompletionProposal p1, ICompletionProposal p2) {
        if (!this.fOrderAlphabetically) {
            int relevanceDif = this.getRelevance(p2) - this.getRelevance(p1);
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            relevanceDif = this.getSortKey(p1).compareToIgnoreCase(this.getSortKey(p2));
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            relevanceDif = this.getSubRelevance(p2) - this.getSubRelevance(p1);
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            return this.getSubSortKey(p1).compareToIgnoreCase(this.getSubSortKey(p2));
        }
        return this.getSortKey(p1).compareToIgnoreCase(this.getSortKey(p2));
    }

    private String getSortKey(ICompletionProposal p) {
        if (p instanceof AbstractScriptCompletionProposal) {
            String sortString = ((AbstractScriptCompletionProposal)p).getSortString();
            if (sortString != null) {
                return sortString;
            }
        } else if (p instanceof ScriptTemplateProposal) {
            return ((ScriptTemplateProposal)p).getTemplateName();
        }
        return p.getDisplayString();
    }

    private int getRelevance(ICompletionProposal obj) {
        if (obj instanceof IScriptCompletionProposal) {
            IScriptCompletionProposal jcp = (IScriptCompletionProposal)obj;
            return jcp.getRelevance();
        }
        if (obj instanceof TemplateProposal) {
            TemplateProposal tp = (TemplateProposal)obj;
            return tp.getRelevance();
        }
        return 0;
    }

    private int getSubRelevance(ICompletionProposal obj) {
        if (obj instanceof IScriptCompletionProposal) {
            return 1;
        }
        if (obj instanceof TemplateProposal) {
            return 2;
        }
        return 0;
    }

    private String getSubSortKey(ICompletionProposal obj) {
        if (obj instanceof TemplateProposal) {
            return ((TemplateProposal)obj).getDisplayString();
        }
        return "";
    }
}

