/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.references.VariableKind;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.ast.RubyDVarExpression;
import org.eclipse.dltk.ruby.ast.RubyMethodArgument;
import org.eclipse.dltk.ruby.ast.RubySingletonMethodDeclaration;
import org.eclipse.dltk.ruby.ast.RubyVariableKind;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.IArgumentsContext;
import org.eclipse.dltk.ruby.typeinference.LocalVariableInfo;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyMethodReference;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ruby.typeinference.VariableTypeGoal;
import org.eclipse.dltk.ruby.typeinference.evaluators.RubyMixinGoalEvaluator;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.ItemReference;
import org.eclipse.dltk.ti.goals.MethodCallsGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class VariableReferenceEvaluator
extends RubyMixinGoalEvaluator {
    private LocalVariableInfo info;
    private MethodCallsGoal callsGoal = null;
    private List results = new ArrayList();
    private MethodDeclaration methodDeclaration;

    public VariableReferenceEvaluator(IGoal goal) {
        super(goal);
    }

    public Object produceResult() {
        return RubyTypeInferencingUtils.combineTypes(this.results);
    }

    private String determineEnclosingMethod(ISourceModule module, ModuleDeclaration decl, VariableReference ref) {
        ASTNode[] wayToNode = ASTUtils.restoreWayToNode(decl, (ASTNode)ref);
        int i = wayToNode.length - 1;
        while (i >= 0) {
            if (wayToNode[i] instanceof MethodDeclaration) {
                this.methodDeclaration = (MethodDeclaration)wayToNode[i];
                String name = this.methodDeclaration.getName();
                if (wayToNode[i] instanceof ModuleDeclaration && !(this.methodDeclaration instanceof RubySingletonMethodDeclaration)) {
                    return name;
                }
                RubyClassType selfClass = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, module, decl, ref.sourceStart());
                if (selfClass == null) {
                    return null;
                }
                return String.valueOf(selfClass.getModelKey()) + MixinModel.SEPARATOR + name;
            }
            --i;
        }
        return null;
    }

    public IGoal[] init() {
        VariableReference ref = this.getGoalVariableReference();
        if (ref.getVariableKind() == RubyVariableKind.LOCAL) {
            IArgumentsContext argumentsContext;
            IEvaluatedType argumentType;
            IContext context = this.goal.getContext();
            ModuleDeclaration rootNode = ((ISourceModuleContext)context).getRootNode();
            VariableReference expression = ref;
            String varName = expression.getName().trim();
            if (context instanceof IArgumentsContext && (argumentType = (argumentsContext = (IArgumentsContext)context).getArgumentType(varName)) != null) {
                this.results.add(argumentType);
                return IGoal.NO_GOALS;
            }
            this.info = RubyTypeInferencingUtils.inspectLocalVariable(rootNode, expression.sourceStart(), varName);
            ArrayList<ExpressionTypeGoal> poss = new ArrayList<ExpressionTypeGoal>();
            if (this.info != null) {
                if (this.info.getLastAssignment() != null && this.info.getLastAssignment().getRight() != null) {
                    ExpressionTypeGoal subgoal = new ExpressionTypeGoal(context, this.info.getLastAssignment().getRight());
                    poss.add(subgoal);
                }
                int i = 0;
                while (i < this.info.getConditionalAssignments().length) {
                    if (this.info.getConditionalAssignments()[i].getRight() != null) {
                        ExpressionTypeGoal subgoal = new ExpressionTypeGoal(context, this.info.getConditionalAssignments()[i].getRight());
                        poss.add(subgoal);
                    }
                    ++i;
                }
            }
            if (poss.size() == 0) {
                int argPos;
                String key = null;
                if (context instanceof ISourceModuleContext) {
                    ISourceModuleContext basicContext = (ISourceModuleContext)context;
                    key = this.determineEnclosingMethod(basicContext.getSourceModule(), basicContext.getRootNode(), ref);
                }
                if (key != null && (argPos = this.determineArgumentPos(this.methodDeclaration, ref.getName())) != -1) {
                    int lastCurly = key.lastIndexOf(MixinModel.SEPARATOR);
                    String parent = null;
                    if (lastCurly != -1) {
                        parent = key.substring(0, lastCurly);
                    }
                    String name = key.substring(lastCurly + 1);
                    this.callsGoal = new MethodCallsGoal(context, name, parent);
                    return new IGoal[]{this.callsGoal};
                }
            }
            return poss.toArray(new IGoal[poss.size()]);
        }
        IEvaluatedType selfClass = RubyTypeInferencingUtils.determineSelfClass(this.mixinModel, this.goal.getContext(), ref.sourceStart());
        if (selfClass instanceof RubyClassType) {
            String selfKey = ((RubyClassType)selfClass).getModelKey();
            return new IGoal[]{new VariableTypeGoal(this.goal.getContext(), ref.getName(), selfKey, ref.getVariableKind())};
        }
        if (selfClass instanceof AmbiguousType) {
            AmbiguousType ambiType = (AmbiguousType)selfClass;
            ArrayList<VariableTypeGoal> goalList = new ArrayList<VariableTypeGoal>();
            IEvaluatedType[] possibleTypes = ambiType.getPossibleTypes();
            int cnt = 0;
            int max = possibleTypes.length;
            while (cnt < max) {
                if (possibleTypes[cnt] instanceof RubyClassType) {
                    String selfKey = ((RubyClassType)possibleTypes[cnt]).getModelKey();
                    goalList.add(new VariableTypeGoal(this.goal.getContext(), ref.getName(), selfKey, ref.getVariableKind()));
                }
                ++cnt;
            }
            return goalList.toArray(new IGoal[goalList.size()]);
        }
        return IGoal.NO_GOALS;
    }

    private int determineArgumentPos(MethodDeclaration decl, String varName) {
        List methodArgs = this.methodDeclaration.getArguments();
        int pos = 0;
        int argPos = -1;
        for (ASTNode marg : methodArgs) {
            RubyMethodArgument rubyMethodArgument;
            if (marg instanceof RubyMethodArgument && (rubyMethodArgument = (RubyMethodArgument)marg).getName().equals(varName)) {
                argPos = pos;
                break;
            }
            ++pos;
        }
        return argPos;
    }

    private VariableReference getGoalVariableReference() {
        ASTNode expression = ((ExpressionTypeGoal)this.goal).getExpression();
        if (expression instanceof VariableReference) {
            return (VariableReference)expression;
        }
        if (expression instanceof RubyDVarExpression) {
            RubyDVarExpression dvar = (RubyDVarExpression)expression;
            return new VariableReference(dvar.sourceStart(), dvar.sourceEnd(), dvar.getName(), (VariableKind)RubyVariableKind.LOCAL);
        }
        return null;
    }

    private ASTNode getArgFromCall(CallExpression expr) {
        List list;
        CallArgumentsList args;
        VariableReference ref = this.getGoalVariableReference();
        if (ref.getVariableKind() != RubyVariableKind.LOCAL) {
            return null;
        }
        String name = ref.getName();
        int argPos = this.determineArgumentPos(this.methodDeclaration, name);
        if (argPos != -1 && (args = expr.getArgs()) != null && argPos < (list = args.getChilds()).size()) {
            ASTNode st = (ASTNode)list.get(argPos);
            if (st instanceof RubyCallArgument) {
                RubyCallArgument rubyCallArgument = (RubyCallArgument)st;
                st = rubyCallArgument.getValue();
            }
            return st;
        }
        return null;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (subgoal == this.callsGoal) {
            ArrayList<ExpressionTypeGoal> possibles = new ArrayList<ExpressionTypeGoal>();
            if (result != null) {
                ItemReference[] refs = (ItemReference[])result;
                int i = 0;
                while (i < refs.length) {
                    ModuleDeclaration decl;
                    IResource resource;
                    ISourceModule module;
                    ASTNode arg;
                    CallExpression node = ((RubyMethodReference)refs[i]).getNode();
                    if (node != null && (arg = this.getArgFromCall(node)) != null && (module = (ISourceModule)DLTKCore.create((IResource)(resource = refs[i].getPosition().getResource()))) != null && (decl = ASTUtils.getAST(module)) != null) {
                        BasicContext callContext = new BasicContext(module, decl);
                        ExpressionTypeGoal g = new ExpressionTypeGoal((IContext)callContext, arg);
                        possibles.add(g);
                    }
                    ++i;
                }
            }
            return possibles.toArray(new IGoal[possibles.size()]);
        }
        if (result != null && !(result instanceof UnknownType)) {
            this.results.add(result);
        }
        return IGoal.NO_GOALS;
    }
}

