/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.core.ArchiveProjectFragmentRequest;
import org.eclipse.dltk.core.search.indexing.core.BuiltinProjectFragmentRequest;
import org.eclipse.dltk.core.search.indexing.core.ExternalProjectFragmentRequest;
import org.eclipse.dltk.core.search.indexing.core.IndexRequest;
import org.eclipse.dltk.core.search.indexing.core.SourceModulesRequest;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;

public class ProjectRequest
extends IndexRequest {
    private final IScriptProject project;

    public ProjectRequest(IProjectIndexer indexer, IScriptProject project) {
        super(indexer);
        this.project = project;
    }

    protected String getName() {
        return this.project.getElementName();
    }

    protected void run() throws CoreException {
        IEnvironment environment = EnvironmentManager.getEnvironment(this.project);
        if (environment == null || !environment.connect()) {
            return;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this.project);
        IProjectFragment[] fragments = this.project.getAllProjectFragments();
        IProjectIndexer.Internal indexer = this.getIndexer();
        SourceModuleCollector moduleCollector = new SourceModuleCollector();
        int i = 0;
        while (i < fragments.length) {
            if (this.isCancelled) {
                return;
            }
            IProjectFragment fragment = fragments[i];
            if (fragment.isBuiltin()) {
                indexer.requestIfNotWaiting(new BuiltinProjectFragmentRequest(indexer, fragment, toolkit, ((BuiltinProjectFragment)fragment).lastModified()));
            } else if (fragment.isArchive()) {
                indexer.requestIfNotWaiting(new ArchiveProjectFragmentRequest(indexer, fragment, toolkit));
            } else if (fragment.isExternal()) {
                indexer.requestIfNotWaiting(new ExternalProjectFragmentRequest(indexer, fragment, toolkit));
            } else if (fragment.getParent().equals(this.project)) {
                fragment.accept(moduleCollector);
            }
            ++i;
        }
        indexer.request(new SourceModulesRequest(indexer, this.project, toolkit, moduleCollector.modules));
    }

    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    static class SourceModuleCollector
    implements IModelElementVisitor {
        final Set<ISourceModule> modules = new HashSet<ISourceModule>();

        SourceModuleCollector() {
        }

        public boolean visit(IModelElement element) {
            if (element.getElementType() == 5) {
                this.modules.add((ISourceModule)element);
                return false;
            }
            return true;
        }
    }
}

