/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.internal.debug.core.model.IScriptBreakpointPathMapperExtension;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;

public class ScriptBreakpointPathMapper
implements IScriptBreakpointPathMapperExtension {
    private HashMap cache;
    private String mapTo;
    private IScriptProject scriptProject;
    private boolean stripSrcFolders;

    ScriptBreakpointPathMapper(IScriptProject project, String mapTo, boolean stripSrcFolders) {
        this.mapTo = mapTo;
        this.scriptProject = project;
        this.stripSrcFolders = stripSrcFolders;
        this.cache = new HashMap();
    }

    public void clearCache() {
        this.cache.clear();
    }

    public URI map(URI uri) {
        if (this.mapTo == null || "".equals(this.mapTo)) {
            return uri;
        }
        if (this.cache.containsKey(uri)) {
            return (URI)this.cache.get(uri);
        }
        IPath projectPath = this.scriptProject.getProject().getLocation();
        if (projectPath == null) {
            return uri;
        }
        Path path = new Path(uri.getPath());
        if (projectPath.isPrefixOf((IPath)path)) {
            IPath temp = path.removeFirstSegments(projectPath.segmentCount()).setDevice(null);
            if (this.stripSrcFolders) {
                temp = this.stripSourceFolders(temp);
            }
            IPath outgoing = new Path(this.mapTo).append(temp);
            URI result = ScriptLineBreakpoint.makeUri(outgoing);
            this.cache.put(uri, result);
            return result;
        }
        this.cache.put(uri, uri);
        return uri;
    }

    private IPath stripSourceFolders(IPath path) {
        try {
            IProjectFragment[] fragments = this.scriptProject.getProjectFragments();
            int i = 0;
            while (i < fragments.length) {
                IProjectFragment frag = fragments[i];
                if (!frag.isExternal() && !frag.isArchive()) {
                    String name = frag.getElementName();
                    if (path.segmentCount() > 0 && path.segment(0).equals(name)) {
                        return path.removeFirstSegments(1);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return path;
    }
}

