/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.compiler.problem.ValidationMultiStatus;
import org.eclipse.dltk.compiler.problem.ValidationStatus;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.ITypeCheck;
import org.eclipse.dltk.javascript.typeinfo.ITypeChecker;
import org.eclipse.dltk.javascript.typeinfo.ITypeCheckerExtension;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.FunctionType;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Parameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.dltk.javascript.validation.IValidatorExtension;
import org.eclipse.dltk.javascript.validation.IValidatorExtension2;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;

public class JSDocValidatorFactory {
    public static ITypeChecker createNopTypeChecker() {
        return new NopTypeChecker();
    }

    public static abstract class AbstractTypeChecker
    implements ITypeChecker {
        private int defaults = 1;

        public int getDefaults() {
            return this.defaults;
        }

        public void setDefaults(int defaults) {
            this.defaults = defaults;
        }

        public void checkType(JSType type, ISourceNode node) {
            this.checkType(type, node, this.getDefaults());
        }

        public void checkType(JSType type, ISourceNode tag, int flags) {
            if (type == null) {
                return;
            }
            if (type instanceof UnionType) {
                for (JSType targetType : ((UnionType)type).getTargets()) {
                    this.checkType(targetType, tag, flags);
                }
            } else if (type instanceof RecordType) {
                for (Member member : ((RecordType)type).getMembers()) {
                    this.checkType(member.getType(), tag, flags);
                }
            } else if (type instanceof FunctionType) {
                FunctionType func = (FunctionType)type;
                this.checkType(((FunctionType)type).getReturnType(), tag, flags);
                for (Parameter parameter : func.getParameters()) {
                    this.checkType(parameter.getType(), tag, flags);
                }
            } else if (!(type instanceof AnyType) && !(type instanceof UndefinedType)) {
                if (type instanceof ArrayType) {
                    this.checkType(((ArrayType)type).getItemType(), tag, flags);
                } else if (type instanceof MapType) {
                    this.checkType(((MapType)type).getKeyType(), tag, flags);
                    this.checkType(((MapType)type).getValueType(), tag, flags);
                } else if (type instanceof SimpleType) {
                    if (type instanceof ParameterizedType) {
                        ParameterizedType parameterized = (ParameterizedType)type;
                        for (JSType param : parameterized.getActualTypeArguments()) {
                            this.checkType(param, tag, flags);
                        }
                        this.checkType(((SimpleType)type).getTarget(), tag, flags, new ITypeCheck[]{new ParameterizedTypeCheck(parameterized)});
                    } else {
                        this.checkType(((SimpleType)type).getTarget(), tag, flags, null);
                    }
                } else if (type instanceof ClassType) {
                    Type t = ((ClassType)type).getTarget();
                    if (t == null) {
                        return;
                    }
                    this.checkType(t, tag, flags, null);
                }
            }
        }

        public abstract void checkType(Type var1, ISourceNode var2, int var3, @Nullable ITypeCheck[] var4);
    }

    static class NopTypeChecker
    implements ITypeChecker {
        NopTypeChecker() {
        }

        public int getDefaults() {
            return 1;
        }

        public void setDefaults(int flags) {
        }

        public void checkType(JSType type, ISourceNode node) {
        }

        public void checkType(JSType type, ISourceNode node, int flags) {
        }

        public void checkType(Type type, ISourceNode node, int flags, ITypeCheck[] checks) {
        }
    }

    private static class ParameterizedTypeCheck
    implements ITypeCheck {
        private final ParameterizedType parameterizedType;

        public ParameterizedTypeCheck(ParameterizedType parameterizedType) {
            this.parameterizedType = parameterizedType;
        }

        public IValidationStatus checkType(ITypeInfoContext context, Type type) {
            if (type instanceof GenericType) {
                GenericType genericType = (GenericType)type;
                EList<TypeVariable> typeVariables = genericType.getTypeParameters();
                int typeVariableCount = typeVariables.size();
                if (typeVariableCount != this.parameterizedType.getActualTypeArguments().size()) {
                    return new ValidationStatus((IProblemIdentifier)JavaScriptProblems.PARAMETERIZED_TYPE_INCORRECT_ARGUMENTS, NLS.bind((String)ValidationMessages.IncorrectNumberOfTypeArguments, (Object)type.getName()));
                }
                ArrayList<ValidationStatus> statuses = null;
                int i = 0;
                while (i < typeVariableCount) {
                    IRType actual;
                    IRType bound;
                    TypeVariable variable = (TypeVariable)typeVariables.get(i);
                    if (variable.getBound() != null && !(bound = RTypes.create(context, variable.getBound())).isAssignableFrom(actual = context.contextualize((JSType)this.parameterizedType.getActualTypeArguments().get(i))).ok()) {
                        if (statuses == null) {
                            statuses = new ArrayList<ValidationStatus>();
                        }
                        statuses.add(new ValidationStatus((IProblemIdentifier)JavaScriptProblems.PARAMETERIZED_TYPE_INCORRECT_ARGUMENTS, NLS.bind((String)ValidationMessages.ParameterizedBoundMismatch, (Object[])new Object[]{actual, variable.getName(), bound, genericType.getName()})));
                    }
                    ++i;
                }
                return ValidationMultiStatus.of(statuses);
            }
            return new ValidationStatus((IProblemIdentifier)JavaScriptProblems.NOT_GENERIC_TYPE, NLS.bind((String)ValidationMessages.NotGenericType, (Object)type.getName()));
        }
    }

    private static class QueueItem {
        final Type type;
        final ISourceNode tag;
        final IValueCollection collection;
        final int flags;
        @Nullable
        final ITypeCheck[] checks;

        public QueueItem(Type type, ISourceNode tag, IValueCollection collection, int flags, @Nullable ITypeCheck[] checks) {
            this.type = type;
            this.tag = tag;
            this.collection = collection;
            this.flags = flags;
            this.checks = checks;
        }
    }

    public static class TypeChecker
    extends AbstractTypeChecker
    implements ITypeCheckerExtension {
        private final List<QueueItem> queue = new ArrayList<QueueItem>();
        private final ITypeInfoContext context;
        private final JSProblemReporter reporter;
        private IValidatorExtension[] extensions;

        public TypeChecker(ITypeInfoContext context, JSProblemReporter reporter) {
            this.context = context;
            this.reporter = reporter;
        }

        public void checkType(JSType type, ISourceNode tag, int flags) {
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidationStatus status;
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    if (extension instanceof IValidatorExtension2 && (status = ((IValidatorExtension2)extension).validateTypeExpression(type)) != null && status != ValidationStatus.OK) {
                        JavaScriptValidations.reportValidationStatus(this.reporter, status, tag, JavaScriptProblems.INACCESSIBLE_TYPE, ValidationMessages.InaccessibleType, type.getName());
                        return;
                    }
                    ++n2;
                }
            }
            super.checkType(type, tag, flags);
        }

        public void checkType(Type type, ISourceNode tag, int flags, @Nullable ITypeCheck[] checks) {
            TypeKind kind = type.getKind();
            if (kind == TypeKind.UNKNOWN) {
                this.queue.add(new QueueItem(type, tag, this.context.currentCollection(), flags, checks));
            } else if (kind == TypeKind.UNRESOLVED) {
                Type resolved = this.context.resolveType(type);
                if (resolved != type && resolved.getKind() != TypeKind.UNKNOWN) {
                    this.checkDeprecatedType(resolved, tag);
                    if (checks != null) {
                        this.doChecks(resolved, tag, checks);
                    }
                } else {
                    this.queue.add(new QueueItem(type, tag, this.context.currentCollection(), flags, checks));
                }
            } else {
                this.checkDeprecatedType(type, tag);
                if (checks != null) {
                    this.doChecks(type, tag, checks);
                }
            }
        }

        public void validate() {
            for (QueueItem item : this.queue) {
                this.doCheckType(this.context.resolveType(item.type), item.tag, item.flags, item.checks, item.collection);
            }
        }

        private void doCheckType(Type type, ISourceNode tag, int flags, @Nullable ITypeCheck[] checks, IValueCollection collection) {
            if (type.eIsProxy()) {
                Assert.isTrue((!type.eIsProxy() ? 1 : 0) != 0, (String)("Type \"" + type.getName() + "\" is a proxy"));
            }
            if (type.getKind() == TypeKind.UNKNOWN) {
                if ((flags & 1) != 0 && collection != null) {
                    if (collection.getChild(type.getName()).exists()) {
                        return;
                    }
                    String className = type.getName();
                    if (className.indexOf(46) != -1) {
                        StringTokenizer st = new StringTokenizer(className, ".");
                        IValueReference child = null;
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (child == null) {
                                child = collection.getChild(token);
                            } else {
                                IValueCollection function;
                                if (child.getKind() == ReferenceKind.FUNCTION && (function = (IValueCollection)child.getAttribute("FUNCTION_SCOPE")) != null) {
                                    child = function.getThis();
                                }
                                child = child.getChild(token);
                            }
                            if (child.exists()) continue;
                            child = null;
                            break;
                        }
                        if (child != null) {
                            return;
                        }
                    }
                }
                this.reportUnknownType(tag, TypeUtil.getName(type));
            } else {
                this.checkDeprecatedType(type, tag);
                if (checks != null) {
                    this.doChecks(type, tag, checks);
                }
            }
        }

        private void doChecks(Type type, ISourceNode tag, ITypeCheck[] checks) {
            ITypeCheck[] iTypeCheckArray = checks;
            int n = checks.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeCheck check = iTypeCheckArray[n2];
                IValidationStatus status = check.checkType(this.context, type);
                if (status != null && status != ValidationStatus.OK) {
                    JavaScriptValidations.reportValidationStatus(this.reporter, status, tag, JavaScriptProblems.INACCESSIBLE_TYPE, ValidationMessages.InaccessibleType, type.getName());
                }
                ++n2;
            }
        }

        private void checkDeprecatedType(Type type, ISourceNode tag) {
            if (type.isDeprecated()) {
                this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DEPRECATED_TYPE, NLS.bind((String)ValidationMessages.DeprecatedType, (Object)TypeUtil.getName(type)), tag.start(), tag.end());
                return;
            }
            if (this.extensions != null) {
                IValidatorExtension[] iValidatorExtensionArray = this.extensions;
                int n = this.extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IValidationStatus status;
                    IValidatorExtension extension = iValidatorExtensionArray[n2];
                    if (extension instanceof IValidatorExtension2 && (status = ((IValidatorExtension2)extension).validateAccessibility(type)) != null && status != ValidationStatus.OK) {
                        JavaScriptValidations.reportValidationStatus(this.reporter, status, tag, JavaScriptProblems.INACCESSIBLE_TYPE, ValidationMessages.InaccessibleType, type.getName());
                        return;
                    }
                    ++n2;
                }
            }
        }

        public void reportUnknownType(ISourceNode tag, String name) {
            this.reportUnknownType(JavaScriptProblems.UNKNOWN_TYPE, tag, name);
        }

        public void reportUnknownType(IProblemIdentifier identifier, ISourceNode node, String name) {
            int start;
            int end;
            if (node instanceof JSDocTag) {
                int index2;
                JSDocTag tag = (JSDocTag)node;
                end = tag.end();
                start = end - tag.value().length();
                int index = tag.value().indexOf(123);
                if (index != -1 && (index2 = tag.value().indexOf(125, index)) != -1) {
                    start = start + index + 1;
                    end = start + index2 - 1;
                }
            } else {
                start = node.start();
                end = node.end();
            }
            this.reporter.reportProblem(identifier, NLS.bind((String)ValidationMessages.UnknownType, (Object)name), start, end);
        }

        public void setExtensions(IValidatorExtension[] extensions) {
            this.extensions = extensions;
        }
    }
}

