/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceableBlock;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class IfStatement
extends Statement
implements ISourceableBlock {
    private Keyword ifKeyword;
    private Keyword elseKeyword;
    private Expression condition;
    private Statement thenStatement;
    private Statement elseStatement = null;
    private int LP = -1;
    private int RP = -1;

    public IfStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.ifKeyword != null) {
                this.ifKeyword.traverse(visitor);
            }
            if (this.elseKeyword != null) {
                this.elseKeyword.traverse(visitor);
            }
            if (this.condition != null) {
                this.condition.traverse(visitor);
            }
            if (this.thenStatement != null) {
                this.thenStatement.traverse(visitor);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Statement getThenStatement() {
        return this.thenStatement;
    }

    public void setThenStatement(Statement thenStatement) {
        this.thenStatement = thenStatement;
    }

    public Statement getElseStatement() {
        return this.elseStatement;
    }

    public void setElseStatement(Statement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public Keyword getIfKeyword() {
        return this.ifKeyword;
    }

    public void setIfKeyword(Keyword keyword) {
        this.ifKeyword = keyword;
    }

    public Keyword getElseKeyword() {
        return this.elseKeyword;
    }

    public void setElseKeyword(Keyword keyword) {
        this.elseKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(indentationString);
        buffer.append("if");
        buffer.append(" (");
        buffer.append(IfStatement.toSourceString(this.condition, indentationString));
        buffer.append(")\n");
        buffer.append(this.getThenStatement().toSourceString(IfStatement.isBlock(this.getThenStatement()) ? indentationString : String.valueOf(indentationString) + "    "));
        if (this.getElseStatement() != null) {
            buffer.append(indentationString);
            buffer.append("else");
            buffer.append("\n");
            buffer.append(this.getElseStatement().toSourceString(IfStatement.isBlock(this.getElseStatement()) ? indentationString : String.valueOf(indentationString) + "    "));
        }
        return buffer.toString();
    }

    private static boolean isBlock(ASTNode node) {
        return node instanceof ISourceableBlock && ((ISourceableBlock)node).isBlock();
    }

    public boolean isBlock() {
        return true;
    }
}

