/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.FunctionMethod;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RTypes;

class FunctionTypeMethodValue
extends ElementValue
implements IValue {
    private ElementValue.TypeValue functionOperator;
    private final IRFunctionType functionType;
    private final FunctionMethod functionMethod;
    private final IRMethod method;

    public FunctionTypeMethodValue(IRFunctionType functionType, FunctionMethod functionMethod) {
        this.functionType = functionType;
        this.functionMethod = functionMethod;
        this.method = functionMethod.create(functionType);
    }

    protected IRMethod getElements() {
        return this.method;
    }

    public ReferenceKind getKind() {
        return ReferenceKind.METHOD;
    }

    public IValue getChild(String name, boolean resolve) {
        if ("()".equals(name)) {
            if (this.functionType.getReturnType() != null) {
                if (this.functionOperator == null) {
                    this.functionOperator = new ElementValue.TypeValue(this.functionType.getReturnType());
                }
                return this.functionOperator;
            }
            return null;
        }
        IValue child = ElementValue.findMemberA(this.getDeclaredType(), name, resolve);
        if (child != null) {
            return child;
        }
        return null;
    }

    public IRType getDeclaredType() {
        return RTypes.FUNCTION;
    }

    public JSTypeSet getDeclaredTypes() {
        return JSTypeSet.singleton(this.getDeclaredType());
    }

    public Object getAttribute(String key, boolean includeReferences) {
        if (IAssignProtection.ATTRIBUTE.equals(key)) {
            return UNASSIGNABLE_METHOD;
        }
        return super.getAttribute(key, includeReferences);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '<' + this.functionType + '.' + (Object)((Object)this.functionMethod) + '>';
    }
}

