/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

public class PackageOrClassValue
extends Value {
    private final String name;
    private final ITypeInferenceContext context;

    public PackageOrClassValue(String name, ITypeInferenceContext context) {
        this.name = name;
        this.context = context;
        Type type = context.getKnownType("Packages." + name, null);
        if (type != null) {
            this.types.add(RTypes.classType(context, type));
        }
    }

    public IValue getChild(String childName, boolean resolve) {
        IValue child = super.getChild(childName, resolve);
        if (child == null) {
            child = this.createChildImpl(childName);
        }
        return child;
    }

    public IValue createChild(String childName, int flags) {
        Value child = this.createChildImpl(childName);
        this.putDirectChild(childName, child);
        return child;
    }

    private Value createChildImpl(String childName) {
        return new PackageOrClassValue(String.valueOf(this.name) + "." + childName, this.context);
    }
}

