/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.internal.javascript.validation.TypeInfoValidator;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.internal.core.CollectingVisitor;
import org.eclipse.dltk.javascript.internal.core.CoreMessages;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSBindings
implements Map<ASTNode, IValueReference> {
    private final ITypeSystem typeSystem;
    private final Map<ASTNode, IValueReference> nodeMap;
    private static final String ATTR_BINDINGS = JSBindings.class.getName();
    private transient Views views;

    protected JSBindings(ITypeSystem typeSystem, Map<ASTNode, IValueReference> nodeMap) {
        this.typeSystem = typeSystem;
        this.nodeMap = nodeMap;
    }

    protected boolean isCacheable() {
        return true;
    }

    public static JSBindings of(Script script) {
        ISourceModule module = (ISourceModule)script.getAttribute(JavaScriptParserUtil.ATTR_MODULE);
        if (module != null) {
            return JSBindings.get(module, script);
        }
        return null;
    }

    public static IValueReference resolveBinding(ASTNode node) {
        JSBindings bindings;
        JSNode jnode;
        Script script;
        if (node instanceof JSNode && (script = (jnode = (JSNode)node).getScript()) != null && (bindings = JSBindings.of(script)) != null) {
            return bindings.get(node);
        }
        return null;
    }

    private static JSBindings buildBindings(IModelElement element, Script script) {
        JSBindings cached = TypeInfoValidator.getCachedBindings(script);
        if (cached != null) {
            return cached;
        }
        TypeInferencer2 inferencer = new TypeInferencer2();
        CollectingVisitor collector = new CollectingVisitor(inferencer);
        inferencer.setModelElement(element);
        inferencer.setVisitor(collector);
        inferencer.doInferencing(script);
        return new JSBindings(inferencer, collector.bindings);
    }

    public static JSBindings of(IModuleSource source) {
        if (source instanceof ISourceModule) {
            return JSBindings.of((ISourceModule)source);
        }
        if (source instanceof IBuildContext) {
            return JSBindings.of((IBuildContext)source);
        }
        Script script = JavaScriptParserUtil.parse((IModuleSource)source, null);
        return JSBindings.buildBindings(source.getModelElement(), script);
    }

    public static JSBindings of(ISourceModule module) {
        Script script = JavaScriptParserUtil.parse((ISourceModule)module, null);
        return JSBindings.get(module, script);
    }

    private static JSBindings get(ISourceModule module, Script script) {
        JSBindings bindings = (JSBindings)script.getAttribute(ATTR_BINDINGS);
        if (bindings != null) {
            return bindings;
        }
        bindings = JSBindings.buildBindings((IModelElement)module, script);
        if (bindings.isCacheable()) {
            script.setAttribute(ATTR_BINDINGS, (Object)bindings);
        }
        return bindings;
    }

    public static JSBindings of(IBuildContext context) {
        ITypeSystem typeSystem = ITypeSystem.CURRENT.get();
        if (typeSystem == null) {
            throw new IllegalStateException(NLS.bind((String)CoreMessages.JSBindings_not_available, (Object)CoreMessages.JSBindings_currentTypeSystem, (Object)"org.eclipse.dltk.javascript.core.buildParticipant.typeinfo"));
        }
        Map bindings = (Map)context.get(TypeInfoValidator.ATTR_BINDINGS);
        if (bindings == null) {
            throw new IllegalStateException(NLS.bind((String)CoreMessages.JSBindings_not_available, (Object)CoreMessages.JSBindings_precomputedBindings, (Object)"org.eclipse.dltk.javascript.core.buildParticipant.typeinfo"));
        }
        return new JSBindings(typeSystem, bindings);
    }

    public ITypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public IValueReference get(ASTNode node) {
        return this.nodeMap.get(node);
    }

    public void run(Runnable runnable) {
        ITypeSystem.CURRENT.runWith(this.typeSystem, runnable);
    }

    public <V> V run(Callable<V> callable) throws Exception {
        return ITypeSystem.CURRENT.runWith(this.typeSystem, callable);
    }

    @Override
    public int size() {
        return this.nodeMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodeMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nodeMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.nodeMap.containsValue(value);
    }

    @Override
    public IValueReference get(Object key) {
        return this.nodeMap.get(key);
    }

    @Override
    public IValueReference put(ASTNode key, IValueReference value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IValueReference remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends ASTNode, ? extends IValueReference> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private synchronized Views getViews() {
        if (this.views == null) {
            this.views = new Views();
        }
        return this.views;
    }

    @Override
    public Set<ASTNode> keySet() {
        Views v = this.getViews();
        if (v.keySet == null) {
            v.keySet = Collections.unmodifiableSet(this.nodeMap.keySet());
        }
        return v.keySet;
    }

    @Override
    public Collection<IValueReference> values() {
        Views v = this.getViews();
        if (v.values == null) {
            v.values = Collections.unmodifiableCollection(this.nodeMap.values());
        }
        return v.values;
    }

    @Override
    public Set<Map.Entry<ASTNode, IValueReference>> entrySet() {
        Views v = this.getViews();
        if (v.entrySet == null) {
            v.entrySet = Collections.unmodifiableSet(this.nodeMap.entrySet());
        }
        return v.entrySet;
    }

    static class Views {
        volatile Set<ASTNode> keySet;
        volatile Collection<IValueReference> values;
        volatile Set<Map.Entry<ASTNode, IValueReference>> entrySet;

        Views() {
        }
    }
}

