/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeExtension2;
import org.eclipse.dltk.javascript.typeinfo.IRTypeTransformer;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.RUnionType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.Type;

public abstract class RType
implements IRType {
    static final boolean DEBUG = false;

    protected final void checkType(Type type) {
        if (type.isProxy()) {
            System.out.println("PROXY " + type.getName());
        }
    }

    public TypeCompatibility isAssignableFrom(IRType type) {
        if (type == RTypes.undefined() || type == RTypes.any()) {
            return TypeCompatibility.TRUE;
        }
        if (type == RTypes.none()) {
            return TypeCompatibility.FALSE;
        }
        if (type instanceof RUnionType) {
            for (IRType part : ((RUnionType)type).targets) {
                if (!this.isAssignableFrom(part).ok()) continue;
                return TypeCompatibility.TRUE;
            }
        }
        return TypeCompatibility.FALSE;
    }

    public final String toString() {
        return this.getName();
    }

    protected TypeCompatibility testAssignableTo(IRType type) {
        return type instanceof IRTypeExtension2 ? ((IRTypeExtension2)((Object)type)).isAssignableTo(this) : TypeCompatibility.FALSE;
    }

    public boolean isExtensible() {
        return false;
    }

    public boolean isJavaScriptObject() {
        return true;
    }

    public boolean isSynthetic() {
        return false;
    }

    public IRType transform(IRTypeTransformer function) {
        return this;
    }

    public IRType normalize() {
        return this;
    }
}

