/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class JavascriptPartitionScanner
extends RuleBasedPartitionScanner {
    public JavascriptPartitionScanner() {
        Token string = new Token((Object)"__javascript_string_double");
        Token stringSingle = new Token((Object)"__javascript_string_single");
        Token multiLineComment = new Token((Object)"__javascript_comment");
        Token singleLineComment = new Token((Object)"__javascript_single_line_comment");
        Token doc = new Token((Object)"__javascript_doc");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)singleLineComment));
        rules.add((Object)new EmptyCommentRule((IToken)multiLineComment));
        rules.add(new MultiLineRule("/**", "*/", (IToken)doc));
        rules.add(new MultiLineRule("/*", "*/", (IToken)multiLineComment));
        rules.add((Object)new JavaScriptStringRule("'", (IToken)stringSingle));
        rules.add((Object)new JavaScriptStringRule("\"", (IToken)string));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    static class EmptyCommentDetector
    implements IWordDetector {
        EmptyCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '/';
        }

        public boolean isWordPart(char c) {
            return c == '*' || c == '/';
        }
    }

    static class EmptyCommentRule
    extends WordRule
    implements IPredicateRule {
        private IToken fSuccessToken;

        public EmptyCommentRule(IToken successToken) {
            super((IWordDetector)new EmptyCommentDetector());
            this.fSuccessToken = successToken;
            this.addWord("/**/", this.fSuccessToken);
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return this.evaluate(scanner);
        }

        public IToken getSuccessToken() {
            return this.fSuccessToken;
        }
    }

    private static class JavaScriptStringRule
    extends SingleLineRule {
        public JavaScriptStringRule(String quote, IToken token) {
            super(quote, quote, token, '\\', true, true);
        }
    }
}

