/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterWriter;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterBlockWithBeginEndNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.FormatterCommentNode;
import org.eclipse.dltk.javascript.formatter.internal.nodes.IBracesConfiguration;

public class BracesNode
extends FormatterBlockWithBeginEndNode {
    private IBracesConfiguration configuration;

    public BracesNode(IFormatterDocument document, IBracesConfiguration configuration) {
        super(document);
        Assert.isNotNull((Object)configuration);
        this.configuration = configuration;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        context.setBlankLines(this.getBlankLinesBefore(context));
        this.printBeforeOpenBrace(context, visitor);
        if (this.configuration.isBracesIndenting()) {
            context.incIndent();
        }
        if (this.getBegin() != null) {
            IFormatterNode[] nodes = this.getBegin();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept(context, visitor);
                ++i;
            }
        }
        boolean printAfterOpenBrace = true;
        List<IFormatterNode> children = this.getChildren();
        for (IFormatterNode formatterNode : children) {
            if (formatterNode instanceof FormatterCommentNode) {
                printAfterOpenBrace = false;
                break;
            }
            if (!(formatterNode instanceof IFormatterTextNode) || ((IFormatterTextNode)formatterNode).getText().indexOf(10) != -1) break;
        }
        if (printAfterOpenBrace) {
            this.printAfterOpenBrace(context, visitor);
        } else {
            visitor.writeText(context, " ");
        }
        boolean indenting = this.isIndenting();
        if (indenting) {
            context.incIndent();
        }
        this.acceptBody(context, visitor);
        if (indenting) {
            context.decIndent();
        }
        this.printBeforeCloseBrace(context, visitor);
        if (this.getEnd() != null) {
            visitor.write(context, this.getEnd().getStartOffset(), this.getEnd().getEndOffset());
        }
        this.printAfterCloseBrace(context, visitor);
        if (this.configuration.isBracesIndenting()) {
            context.decIndent();
        }
    }

    private boolean isStatementNewLine() {
        return this.getDocument().getBoolean("formatter.statement.new.line");
    }

    private void printBeforeCloseBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertBeforeCloseBrace()) {
            case 2: {
                if (!this.isStatementNewLine()) break;
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 3: {
                visitor.appendToPreviousLine(context, "");
                visitor.skipNextLineBreaks(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    private void printAfterOpenBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertAfterOpenBrace()) {
            case 2: {
                if (!this.isStatementNewLine()) break;
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
                break;
            }
            default: {
                if (this.configuration.insertBeforeOpenBrace() == 2) break;
                visitor.appendToPreviousLine(context, "");
                if (this.configuration.insertBeforeCloseBrace() != 3) {
                    visitor.writeText(context, " ");
                }
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    private void printBeforeOpenBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertBeforeOpenBrace()) {
            case 2: {
                if (!this.isStatementNewLine()) break;
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, "");
                visitor.writeText(context, " ");
                visitor.skipNextLineBreaks(context);
                break;
            }
            case 3: {
                visitor.appendToPreviousLine(context, "");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    private void printAfterCloseBrace(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        switch (this.configuration.insertAfterCloseBrace()) {
            case 2: {
                if (!this.isStatementNewLine()) break;
                context.setBlankLines(-1);
                visitor.writeLineBreak(context);
                break;
            }
            case 1: {
                visitor.appendToPreviousLine(context, " ");
                visitor.skipNextLineBreaks(context);
            }
        }
    }

    protected boolean isIndenting() {
        return this.configuration.isIndenting();
    }
}

