/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.LoopStatement;
import org.eclipse.dltk.javascript.ast.Statement;

public class ForStatement
extends LoopStatement {
    private Keyword forKeyword;
    private Expression initial;
    private Expression condition;
    private Expression step;
    private int LP = -1;
    private int RP = -1;
    private int initialSemic = -1;
    private int conditionSemic = -1;

    public ForStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            Statement body;
            if (this.forKeyword != null) {
                this.forKeyword.traverse(visitor);
            }
            if (this.initial != null) {
                this.initial.traverse(visitor);
            }
            if (this.condition != null) {
                this.condition.traverse(visitor);
            }
            if (this.step != null) {
                this.step.traverse(visitor);
            }
            if ((body = this.getBody()) != null) {
                body.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getInitial() {
        return this.initial;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getStep() {
        return this.step;
    }

    public void setInitial(Expression initial) {
        this.initial = initial;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public void setStep(Expression step) {
        this.step = step;
    }

    public Keyword getForKeyword() {
        return this.forKeyword;
    }

    public void setForKeyword(Keyword keyword) {
        this.forKeyword = keyword;
    }

    public int getLP() {
        return this.LP;
    }

    public void setLP(int LP) {
        this.LP = LP;
    }

    public int getRP() {
        return this.RP;
    }

    public void setRP(int RP) {
        this.RP = RP;
    }

    public int getConditionalSemicolonPosition() {
        return this.conditionSemic;
    }

    public void setConditionalSemicolonPosition(int semic) {
        this.conditionSemic = semic;
    }

    public int getInitialSemicolonPosition() {
        return this.initialSemic;
    }

    public void setInitialSemicolonPosition(int semic) {
        this.initialSemic = semic;
    }

    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(indentationString);
        buffer.append("for");
        buffer.append(" (");
        if (this.getInitial() != null) {
            buffer.append(this.getInitial().toSourceString(indentationString));
        }
        buffer.append("; ");
        if (this.getCondition() != null) {
            buffer.append(this.getCondition().toSourceString(indentationString));
        }
        buffer.append("; ");
        if (this.getStep() != null) {
            buffer.append(this.getStep().toSourceString(indentationString));
        }
        buffer.append(")");
        if (this.getBody() != null) {
            buffer.append("\n");
            buffer.append(this.getBody().toSourceString(indentationString));
        } else {
            buffer.append(";\n");
        }
        return buffer.toString();
    }
}

