/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter.profile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.formatter.profile.CustomProfile;
import org.eclipse.dltk.formatter.profile.ProfilesMessages;
import org.eclipse.dltk.internal.ui.DLTKUIException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.formatter.IProfile;
import org.eclipse.dltk.ui.formatter.IProfileStore;
import org.eclipse.dltk.ui.formatter.IProfileVersioner;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileStore
implements IProfileStore {
    public static final String ENCODING = "UTF-8";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_PROFILE_FORMATTER = "formatter";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private final Map<String, String> defaults;
    private IProfileVersioner versioner;

    public ProfileStore(IProfileVersioner versioner, Map<String, String> defaults) {
        this.versioner = versioner;
        this.defaults = defaults;
    }

    public IProfileVersioner getVersioner() {
        return this.versioner;
    }

    public String writeProfiles(Collection<IProfile> profiles) throws CoreException {
        String string;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            String val;
            ProfileStore.writeProfilesToStream(profiles, stream, ENCODING, this.versioner);
            try {
                val = stream.toString(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                val = stream.toString();
            }
            string = val;
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public List<IProfile> readProfilesFromString(String profiles) throws CoreException {
        if (profiles != null && profiles.length() > 0) {
            Collection collection;
            byte[] bytes;
            try {
                bytes = profiles.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = profiles.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                Collection res = this.readProfilesFromStream(is);
                if (res != null) {
                    int i = 0;
                    while (i < res.size()) {
                        this.versioner.update((IProfile)res.get(i));
                        ++i;
                    }
                }
                collection = res;
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            return collection;
        }
        return null;
    }

    public List<IProfile> readProfilesFromStream(InputStream is) throws CoreException {
        return this.readProfilesFromSource(new InputSource(is));
    }

    public List<IProfile> readProfilesFromFile(File file) throws CoreException {
        Collection collection;
        FileInputStream reader = new FileInputStream(file);
        try {
            collection = this.readProfilesFromStream(reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (IOException e) {
                throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_readingProblems);
            }
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return collection;
    }

    private List<IProfile> readProfilesFromSource(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_readingProblems);
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_readingProblems);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_readingProblems);
        }
        return handler.getProfiles();
    }

    public void writeProfilesToFile(Collection<IProfile> profiles, File file) throws CoreException {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(profiles, stream, ENCODING, this.versioner);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_serializingProblems);
        }
    }

    public static void writeProfilesToStream(Collection<IProfile> profiles, OutputStream stream, String encoding, IProfileVersioner versioner) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            document.appendChild(rootElement);
            for (IProfile profile : profiles) {
                if (profile.isBuiltInProfile()) continue;
                Element profileElement = ProfileStore.createProfileElement(profile, document, versioner);
                rootElement.appendChild(profileElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_serializingProblems);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, ProfilesMessages.ProfileStore_serializingProblems);
        }
    }

    private static Element createProfileElement(IProfile profile, Document document, IProfileVersioner versioner) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        element.setAttribute(XML_ATTRIBUTE_PROFILE_FORMATTER, profile.getFormatterId());
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profile.getVersion()));
        for (Map.Entry entry : profile.getSettings().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null) {
                Element setting = document.createElement(XML_NODE_SETTING);
                setting.setAttribute(XML_ATTRIBUTE_ID, key);
                setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
                element.appendChild(setting);
                continue;
            }
            DLTKUIPlugin.logErrorMessage((String)NLS.bind((String)ProfilesMessages.ProfileStore_noValueForKey, (Object)key));
        }
        return element;
    }

    private static DLTKUIException createException(Throwable t, String message) {
        return new DLTKUIException((IStatus)new Status(4, "org.eclipse.dltk.ui", message, t));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProfileDefaultHandler
    extends DefaultHandler {
        private List<IProfile> fProfiles;
        private int fVersion;
        private String fName;
        private Map<String, String> fSettings;
        private String fFormatter;

        private ProfileDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ProfileStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fFormatter = attributes.getValue(ProfileStore.XML_ATTRIBUTE_PROFILE_FORMATTER);
                try {
                    this.fVersion = Integer.parseInt(attributes.getValue(ProfileStore.XML_ATTRIBUTE_VERSION));
                }
                catch (NumberFormatException ex) {
                    throw new SAXException(ex);
                }
                this.fSettings = new HashMap<String, String>(200);
            } else if (qName.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList<IProfile>();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                for (Map.Entry entry : ProfileStore.this.defaults.entrySet()) {
                    if (this.fSettings.containsKey(entry.getKey())) continue;
                    this.fSettings.put((String)entry.getKey(), (String)entry.getValue());
                }
                this.fProfiles.add(new CustomProfile(this.fName, this.fSettings, this.fFormatter, this.fVersion));
                this.fName = null;
                this.fSettings = null;
                this.fFormatter = null;
                this.fVersion = 1;
            }
        }

        public List<IProfile> getProfiles() {
            return this.fProfiles;
        }
    }
}

