/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.WhileStatement;

public class DoWhileStatement
extends WhileStatement
implements ISemicolonStatement {
    private Keyword doKeyword;
    private int semi = -1;

    public DoWhileStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            Statement body;
            if (this.getWhileKeyword() != null) {
                this.getWhileKeyword().traverse(visitor);
            }
            if (this.getCondition() != null) {
                this.getCondition().traverse(visitor);
            }
            if (this.doKeyword != null) {
                this.doKeyword.traverse(visitor);
            }
            if ((body = this.getBody()) != null) {
                body.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Keyword getDoKeyword() {
        return this.doKeyword;
    }

    public void setDoKeyword(Keyword keyword) {
        this.doKeyword = keyword;
    }

    public int getSemicolonPosition() {
        return this.semi;
    }

    public void setSemicolonPosition(int semi) {
        this.semi = semi;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getLP() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getRP() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.getSemicolonPosition() > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(indentationString);
        buffer.append("do");
        buffer.append("\n");
        buffer.append(this.getBody().toSourceString(indentationString));
        buffer.append(indentationString);
        buffer.append("while");
        buffer.append(" (");
        buffer.append(this.getCondition().toSourceString(indentationString));
        buffer.append(");\n");
        return buffer.toString();
    }
}

