/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.testing;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.testing.util.NumberUtils;
import org.eclipse.dltk.testing.ITestingEngine;
import org.eclipse.dltk.testing.TestingEngineDetectResult;
import org.eclipse.dltk.utils.NatureExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestingEngineManager
extends NatureExtensionManager<ITestingEngine> {
    private static final String EXTENSION_POINT = "org.eclipse.dltk.testing.engine";
    private static final String PRIORITY_ATTR = "priority";
    private final Comparator<Object> descriptorComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            Descriptor descriptor1 = (Descriptor)o1;
            Descriptor descriptor2 = (Descriptor)o2;
            return descriptor1.priority - descriptor2.priority;
        }
    };
    private static TestingEngineManager instance = null;

    private TestingEngineManager() {
        super(EXTENSION_POINT, ITestingEngine.class);
    }

    protected Object createDescriptor(IConfigurationElement confElement) {
        String strPriority = confElement.getAttribute(PRIORITY_ATTR);
        int priority = NumberUtils.toInt(strPriority);
        return new Descriptor(confElement, priority);
    }

    protected void initializeDescriptors(List<Object> descriptors) {
        Collections.sort(descriptors, this.descriptorComparator);
    }

    protected Object createInstanceByDescriptor(Object descriptor) throws CoreException {
        Descriptor engineDescriptor = (Descriptor)descriptor;
        return super.createInstanceByDescriptor((Object)engineDescriptor.element);
    }

    protected ITestingEngine[] createEmptyResult() {
        return new ITestingEngine[0];
    }

    private static synchronized TestingEngineManager getInstance() {
        if (instance == null) {
            instance = new TestingEngineManager();
        }
        return instance;
    }

    public static ITestingEngine[] getEngines(String natureId) {
        return (ITestingEngine[])TestingEngineManager.getInstance().getInstances(natureId);
    }

    public static ITestingEngine getEngine(String engineId) {
        if (engineId != null) {
            ITestingEngine[] engines = (ITestingEngine[])TestingEngineManager.getInstance().getAllInstances();
            int i = 0;
            while (i < engines.length) {
                ITestingEngine engine = engines[i];
                if (engineId.equals(engine.getId())) {
                    return engine;
                }
                ++i;
            }
        }
        return null;
    }

    public static TestingEngineDetectResult detect(ITestingEngine[] engines, ISourceModule module) {
        IStatus infoStatus = null;
        ITestingEngine infoEngine = null;
        int i = 0;
        while (i < engines.length) {
            ITestingEngine engine = engines[i];
            IStatus status = engine.validateSourceModule(module);
            if (status != null) {
                if (status.isOK()) {
                    return new TestingEngineDetectResult(engine, status);
                }
                if (status.getSeverity() == 1 && infoStatus == null) {
                    infoStatus = status;
                    infoEngine = engine;
                }
            }
            ++i;
        }
        if (infoEngine != null) {
            return new TestingEngineDetectResult(infoEngine, infoStatus);
        }
        return null;
    }

    private static class Descriptor {
        final IConfigurationElement element;
        final int priority;

        public Descriptor(IConfigurationElement confElement, int priority) {
            this.element = confElement;
            this.priority = priority;
        }
    }
}

