/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.internal.core.TypeSystems;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.MetaType;
import org.eclipse.dltk.javascript.typeinfo.RSimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class DefaultMetaType
implements MetaType {
    public static final MetaType DEFAULT = new Instance();

    public IRType toRType(ITypeSystem typeSystem, Type type) {
        return new RSimpleType(typeSystem, type);
    }

    public IRType toRType(IRTypeDeclaration declaration) {
        return new RSimpleType(declaration);
    }

    public String toString() {
        return this.getId();
    }

    public ITypeSystem getPreferredTypeSystem(Type type) {
        Resource resource = type.eResource();
        if (resource != null && resource == Types.OBJECT.eResource()) {
            return TypeSystems.GLOBAL;
        }
        return null;
    }

    static class Instance
    extends DefaultMetaType {
        Instance() {
        }

        public String getId() {
            return String.valueOf(MetaType.class.getName()) + ".DEFAULT";
        }
    }
}

