/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.index.sql.Container;
import org.eclipse.dltk.core.index.sql.DbFactory;
import org.eclipse.dltk.core.index.sql.Element;
import org.eclipse.dltk.core.index.sql.File;
import org.eclipse.dltk.core.index.sql.IElementDao;
import org.eclipse.dltk.core.index.sql.IElementHandler;
import org.eclipse.dltk.core.index.sql.h2.H2Index;
import org.eclipse.dltk.core.index2.search.ISearchEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2Cache {
    private static final ILock containerLock = Job.getJobManager().newLock();
    private static final Map<Integer, Container> containerById = new HashMap<Integer, Container>();
    private static final ILock fileLock = Job.getJobManager().newLock();
    private static final Map<Integer, Map<Integer, File>> filesByContainer = new HashMap<Integer, Map<Integer, File>>();
    private static final ILock elementLock = Job.getJobManager().newLock();
    private static final Map<Integer, Map<Integer, List<Element>>> elementsMap = new HashMap<Integer, Map<Integer, List<Element>>>();
    private static final ILock loadedLock = Job.getJobManager().newLock();
    private static boolean isLoaded;

    public static void addContainer(Container container) {
        containerLock.acquire();
        try {
            int containerId = container.getId();
            containerById.put(containerId, container);
        }
        finally {
            containerLock.release();
        }
    }

    public static void addElement(Element element) {
        elementLock.acquire();
        try {
            int fileId;
            List<Element> elementsSet;
            int elementType = element.getType();
            Map<Integer, List<Element>> elementsByFile = elementsMap.get(elementType);
            if (elementsByFile == null) {
                elementsByFile = new HashMap<Integer, List<Element>>();
                elementsMap.put(elementType, elementsByFile);
            }
            if ((elementsSet = elementsByFile.get(fileId = element.getFileId())) == null) {
                elementsSet = new LinkedList<Element>();
                elementsByFile.put(fileId, elementsSet);
            }
            elementsSet.add(element);
        }
        finally {
            elementLock.release();
        }
    }

    public static void addFile(File file) {
        fileLock.acquire();
        try {
            int containerId = file.getContainerId();
            Map<Integer, File> files = filesByContainer.get(containerId);
            if (files == null) {
                files = new HashMap<Integer, File>();
                filesByContainer.put(containerId, files);
            }
            files.put(file.getId(), file);
        }
        finally {
            fileLock.release();
        }
    }

    public static void deleteContainerById(int id) {
        containerLock.acquire();
        try {
            containerById.remove(id);
            H2Cache.deleteFilesByContainerId(id);
        }
        finally {
            containerLock.release();
        }
    }

    public static void deleteContainerByPath(String path) {
        containerLock.acquire();
        try {
            Container container = H2Cache.selectContainerByPath(path);
            if (container != null) {
                H2Cache.deleteContainerById(container.getId());
            }
        }
        finally {
            containerLock.release();
        }
    }

    public static void deleteElementsByFileId(int id) {
        elementLock.acquire();
        try {
            for (Map<Integer, List<Element>> elementsByFile : elementsMap.values()) {
                elementsByFile.remove(id);
            }
        }
        finally {
            elementLock.release();
        }
    }

    public static void deleteFileByContainerIdAndPath(int containerId, String path) {
        fileLock.acquire();
        try {
            File file = H2Cache.selectFileByContainerIdAndPath(containerId, path);
            if (file != null) {
                H2Cache.deleteFileById(file.getId());
            }
        }
        finally {
            fileLock.release();
        }
    }

    public static void deleteFileById(int id) {
        fileLock.acquire();
        try {
            Iterator<Map<Integer, File>> i = filesByContainer.values().iterator();
            while (i.hasNext()) {
                i.next().remove(id);
            }
            H2Cache.deleteElementsByFileId(id);
        }
        finally {
            fileLock.release();
        }
    }

    public static void deleteFilesByContainerId(int id) {
        fileLock.acquire();
        try {
            Map<Integer, File> files = filesByContainer.remove(id);
            if (files != null) {
                Iterator<Integer> i = files.keySet().iterator();
                while (i.hasNext()) {
                    H2Cache.deleteElementsByFileId(i.next());
                }
            }
        }
        finally {
            fileLock.release();
        }
    }

    public static Container selectContainerById(int id) {
        containerLock.acquire();
        try {
            Container container = containerById.get(id);
            return container;
        }
        finally {
            containerLock.release();
        }
    }

    public static Container selectContainerByPath(String path) {
        containerLock.acquire();
        try {
            for (Container container : containerById.values()) {
                if (!container.getPath().equals(path)) continue;
                Container container2 = container;
                return container2;
            }
            return null;
        }
        finally {
            containerLock.release();
        }
    }

    public static Collection<Element> selectElementsByFileId(int id) {
        elementLock.acquire();
        try {
            LinkedList<Element> elements = new LinkedList<Element>();
            for (Map<Integer, List<Element>> elementsByFile : elementsMap.values()) {
                List<Element> l = elementsByFile.get(id);
                if (l == null) continue;
                elements.addAll(l);
            }
            LinkedList<Element> linkedList = elements;
            return linkedList;
        }
        finally {
            elementLock.release();
        }
    }

    public static File selectFileByContainerIdAndPath(int containerId, String path) {
        fileLock.acquire();
        try {
            Map<Integer, File> files = filesByContainer.get(containerId);
            if (files != null) {
                for (File file : files.values()) {
                    if (!file.getPath().equals(path)) continue;
                    File file2 = file;
                    return file2;
                }
            }
        }
        finally {
            fileLock.release();
        }
        return null;
    }

    public static File selectFileById(int id) {
        fileLock.acquire();
        try {
            Iterator<Map<Integer, File>> i = filesByContainer.values().iterator();
            while (i.hasNext()) {
                File file = i.next().get(id);
                if (file == null) continue;
                File file2 = file;
                return file2;
            }
            return null;
        }
        finally {
            fileLock.release();
        }
    }

    public static Collection<File> selectFilesByContainerId(int id) {
        fileLock.acquire();
        try {
            Map<Integer, File> files = filesByContainer.get(id);
            if (files != null) {
                Collection<File> collection = files.values();
                return collection;
            }
            List<File> list = Collections.emptyList();
            return list;
        }
        finally {
            fileLock.release();
        }
    }

    public static Collection<Element> searchElements(String pattern, ISearchEngine.MatchRule matchRule, int elementType, int trueFlags, int falseFlags, String qualifier, String parent, int[] filesId, int[] containersId, String natureId, int limit) {
        int n;
        int n2;
        int[] nArray;
        HashSet<Integer> filesIds = new HashSet<Integer>();
        if (filesId != null) {
            nArray = filesId;
            n2 = filesId.length;
            n = 0;
            while (n < n2) {
                int fileId = nArray[n];
                filesIds.add(fileId);
                ++n;
            }
        } else if (containersId != null) {
            containerLock.acquire();
            try {
                nArray = containersId;
                n2 = containersId.length;
                n = 0;
                while (n < n2) {
                    int containerId = nArray[n];
                    fileLock.acquire();
                    try {
                        Map<Integer, File> files = filesByContainer.get(containerId);
                        if (files != null) {
                            filesIds.addAll(files.keySet());
                        }
                    }
                    finally {
                        fileLock.release();
                    }
                    ++n;
                }
            }
            finally {
                containerLock.release();
            }
        }
        elementLock.acquire();
        try {
            HashSet<String> patternSet = null;
            Pattern posixPattern = null;
            String patternLC = null;
            String patternUC = null;
            if (pattern != null) {
                patternLC = pattern.toLowerCase();
                patternUC = pattern.toUpperCase();
            }
            if (matchRule == ISearchEngine.MatchRule.SET) {
                String[] parts;
                patternSet = new HashSet<String>();
                String[] stringArray = parts = pattern.split(",");
                int n3 = parts.length;
                int n4 = 0;
                while (n4 < n3) {
                    String part = stringArray[n4];
                    if (part.length() > 0) {
                        patternSet.add(part.toLowerCase());
                    }
                    ++n4;
                }
            } else if (matchRule == ISearchEngine.MatchRule.PATTERN) {
                posixPattern = H2Cache.createPosixPattern(pattern);
            }
            LinkedList<Element> result = new LinkedList<Element>();
            Map<Integer, List<Element>> elementsByFile = elementsMap.get(elementType);
            if (elementsByFile != null) {
                if (filesIds.size() == 0) {
                    Iterator<List<Element>> i = elementsByFile.values().iterator();
                    while (i.hasNext()) {
                        H2Cache.searchInElements(i.next(), result, pattern, matchRule, trueFlags, falseFlags, qualifier, parent, patternSet, posixPattern, patternLC, patternUC, limit);
                    }
                } else {
                    for (Integer fileId : filesIds) {
                        H2Cache.searchInElements(elementsByFile.get(fileId), result, pattern, matchRule, trueFlags, falseFlags, qualifier, parent, patternSet, posixPattern, patternLC, patternUC, limit);
                    }
                }
            }
            LinkedList<Element> linkedList = result;
            return linkedList;
        }
        finally {
            elementLock.release();
        }
    }

    private static void searchInElements(List<Element> elements, List<Element> result, String pattern, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, String qualifier, String parent, Set<String> patternSet, Pattern posixPattern, String patternLC, String patternUC, int limit) {
        if (elements != null) {
            for (Element element : elements) {
                if (!H2Cache.elementMatches(element, pattern, matchRule, trueFlags, falseFlags, qualifier, parent, patternSet, posixPattern, patternLC, patternUC)) continue;
                result.add(element);
                if (--limit == 0) break;
            }
        }
    }

    private static boolean elementMatches(Element element, String pattern, ISearchEngine.MatchRule matchRule, int trueFlags, int falseFlags, String qualifier, String parent, Set<String> patternSet, Pattern posixPattern, String patternLC, String patternUC) {
        if (!(trueFlags != 0 && (element.getFlags() & trueFlags) == 0 || falseFlags != 0 && (element.getFlags() & falseFlags) != 0 || qualifier != null && qualifier.length() != 0 && !qualifier.equals(element.getQualifier()) || parent != null && parent.length() != 0 && !parent.equals(element.getParent()))) {
            String elementName = element.getName();
            if (pattern == null || pattern.length() == 0 || matchRule == ISearchEngine.MatchRule.EXACT && pattern.equalsIgnoreCase(elementName) || matchRule == ISearchEngine.MatchRule.PREFIX && H2Cache.startsWithIgnoreCase(elementName, patternLC) || matchRule == ISearchEngine.MatchRule.CAMEL_CASE && element.getCamelCaseName() != null && element.getCamelCaseName().startsWith(patternUC) || matchRule == ISearchEngine.MatchRule.SET && patternSet.contains(elementName.toLowerCase()) || matchRule == ISearchEngine.MatchRule.PATTERN && posixPattern.matcher(elementName).matches()) {
                return true;
            }
        }
        return false;
    }

    private static Pattern createPosixPattern(String pattern) {
        StringBuilder buf = new StringBuilder();
        boolean inQuoted = false;
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '*') {
                if (inQuoted) {
                    buf.append("\\E");
                    inQuoted = false;
                }
                buf.append(".*");
            } else if (ch == '?') {
                if (inQuoted) {
                    buf.append("\\E");
                    inQuoted = false;
                }
                buf.append(".?");
            } else {
                if (!inQuoted) {
                    buf.append("\\Q");
                    inQuoted = true;
                }
                buf.append(ch);
            }
            ++i;
        }
        return Pattern.compile(buf.toString(), 2);
    }

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        return H2Cache.startsWith(str, prefix, true);
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean isLoaded() {
        loadedLock.acquire();
        try {
            boolean bl = isLoaded;
            return bl;
        }
        finally {
            loadedLock.release();
        }
    }

    public static void load() {
        block12: {
            loadedLock.acquire();
            try {
                if (isLoaded) break block12;
                try {
                    try {
                        DbFactory dbFactory = DbFactory.getInstance();
                        Connection connection = dbFactory.createConnection();
                        try {
                            IElementDao elementDao = dbFactory.getElementDao();
                            elementDao.search(connection, null, ISearchEngine.MatchRule.PREFIX, 8, 0, 0, null, null, null, null, "org.eclipse.php.core.PHPNature", 0, false, new IElementHandler(){

                                public void handle(Element element) {
                                }
                            }, (IProgressMonitor)new NullProgressMonitor());
                            elementDao.search(connection, null, ISearchEngine.MatchRule.PREFIX, 7, 0, 0, null, null, null, null, "org.eclipse.php.core.PHPNature", 0, false, new IElementHandler(){

                                public void handle(Element element) {
                                }
                            }, (IProgressMonitor)new NullProgressMonitor());
                            elementDao.search(connection, null, ISearchEngine.MatchRule.PREFIX, 9, 0, 0, null, null, null, null, "org.eclipse.php.core.PHPNature", 0, false, new IElementHandler(){

                                public void handle(Element element) {
                                }
                            }, (IProgressMonitor)new NullProgressMonitor());
                            elementDao.search(connection, null, ISearchEngine.MatchRule.PREFIX, 12, 0, 0, null, null, null, null, "org.eclipse.php.core.PHPNature", 0, false, new IElementHandler(){

                                public void handle(Element element) {
                                }
                            }, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            connection.close();
                        }
                    }
                    catch (SQLException e) {
                        if (H2Index.DEBUG) {
                            e.printStackTrace();
                        }
                        isLoaded = true;
                    }
                }
                finally {
                    isLoaded = true;
                }
            }
            finally {
                loadedLock.release();
            }
        }
    }
}

