/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclPackagesFactory;
import org.eclipse.dltk.tcl.core.packages.TclProjectInfo;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.text.Messages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IAnnotationResolution;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

final class TclRequirePackageCorrectionMarkerResolution
implements IMarkerResolution,
IAnnotationResolution {
    private String pkgName;
    private IScriptProject project;
    private ISourceModule module;

    public TclRequirePackageCorrectionMarkerResolution(String pkgName, IScriptProject scriptProject, ISourceModule module) {
        this.pkgName = pkgName;
        this.project = scriptProject;
        this.module = module;
    }

    public String getLabel() {
        return Messages.TclRequirePackageCorrectionMarkerResolution_SpecifyPackagesResolutionLabel;
    }

    private boolean resolve() {
        block8: {
            HashSet<String> pkgs;
            HashSet pAutoNames;
            HashSet pnames;
            block9: {
                IInterpreterInstall install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.project);
                if (install == null) break block8;
                pnames = new HashSet();
                pAutoNames = new HashSet();
                InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)this.project, pnames, pAutoNames);
                Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
                final ArrayList names = new ArrayList();
                names.addAll(packages);
                Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
                ListDialog dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()){

                    protected int getTableStyle() {
                        return 2818;
                    }
                };
                dialog.setTitle(Messages.TclRequirePackageCorrectionMarkerResolution_SpecifyPackagesTitle);
                dialog.setContentProvider(new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        return names.toArray();
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                });
                dialog.setLabelProvider((ILabelProvider)new PackagesLabelProvider(install));
                dialog.setInput(names);
                pkgs = new HashSet<String>();
                if (dialog.open() == 0) {
                    TclProjectInfo info = TclPackagesManager.getTclProject((String)this.project.getElementName());
                    TclModuleInfo moduleInfo = info.findModule(this.module.getHandleIdentifier());
                    if (moduleInfo == null) {
                        moduleInfo = TclPackagesFactory.eINSTANCE.createTclModuleInfo();
                        moduleInfo.setHandle(this.module.getHandleIdentifier());
                        moduleInfo.setExternal(this.module instanceof IExternalSourceModule);
                        info.getModules().add((Object)moduleInfo);
                    }
                    Object[] result = dialog.getResult();
                    UserCorrection correction = TclPackagesFactory.eINSTANCE.createUserCorrection();
                    correction.setOriginalValue(this.pkgName);
                    moduleInfo.getPackageCorrections().add((Object)correction);
                    int i = 0;
                    while (i < result.length) {
                        String pkg = (String)result[i];
                        pkgs.add(pkg);
                        correction.getUserValue().add((Object)pkg);
                        ++i;
                    }
                    TclPackagesManager.save();
                    break block9;
                }
                return false;
            }
            try {
                if (pnames.addAll(pkgs)) {
                    InterpreterContainerHelper.setInterpreterContainerDependencies((IScriptProject)this.project, pnames, pAutoNames);
                } else {
                    ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(new IModelElement[]{this.project}, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
            catch (CoreException e) {
                TclUI.error("require package resolve error", e);
            }
        }
        return false;
    }

    public void run(IMarker marker) {
        this.resolve();
    }

    public void run(IScriptAnnotation annotation, IDocument document) {
        block3: {
            if (this.resolve()) {
                ISourceModule module = annotation.getSourceModule();
                try {
                    module.reconcile(true, null, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public class PackagesLabelProvider
    extends LabelProvider {
        private IInterpreterInstall install;

        public PackagesLabelProvider(IInterpreterInstall install) {
            this.install = install;
            if (install == null) {
                install = ScriptRuntime.getDefaultInterpreterInstall((String)"org.eclipse.dltk.tcl.core.nature", (IEnvironment)LocalEnvironment.getInstance());
            }
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                Set names;
                String packageName = (String)element;
                if (this.install != null && !(names = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)this.install)).contains(packageName)) {
                    return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.error_obj.gif");
                }
            }
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.package_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return super.getText(element);
        }
    }
}

