/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.scriptview;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDragSupport;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDropSupport;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerLabelProvider;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.scriptview.CustomHashtable;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerActionGroup;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.internal.ui.scriptview.WorkingSetAwareContentProvider;
import org.eclipse.dltk.internal.ui.scriptview.WorkingSetAwareModelElementSorter;
import org.eclipse.dltk.internal.ui.scriptview.WorkingSetDropAdapter;
import org.eclipse.dltk.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.IScriptExplorerViewPart;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.actions.CustomFiltersActionGroup;
import org.eclipse.dltk.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.ui.viewsupport.FilterUpdater;
import org.eclipse.dltk.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.dltk.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.dltk.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;

public class ScriptExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IScriptExplorerViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.dltk.ui/perf/explorer/createPartControl";
    private static final String PERF_MAKE_ACTIONS = "org.eclipse.dltk.ui/perf/explorer/makeActions";
    protected static final int HIERARCHICAL_LAYOUT = 1;
    protected static final int FLAT_LAYOUT = 2;
    public static final int PROJECTS_AS_ROOTS = 1;
    public static final int WORKING_SETS_AS_ROOTS = 2;
    @Deprecated
    public static final String VIEW_ID = "org.eclipse.dltk.ui.ScriptExplorer";
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_GROUP_LIBRARIES = "group_libraries";
    private static final String TAG_ROOT_MODE = "rootMode";
    private static final String TAG_LINK_EDITOR = "linkWithEditor";
    private static final String TAG_MEMENTO = "memento";
    private boolean fIsCurrentLayoutFlat;
    private boolean fShowLibrariesNode;
    private boolean fLinkingEnabled;
    private int fRootMode;
    private WorkingSetModel fWorkingSetModel;
    private ScriptExplorerLabelProvider fLabelProvider;
    private DecoratingModelLabelProvider fDecoratingLabelProvider;
    private ScriptExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private ScriptExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private ISelection fLastOpenSelection;
    private final ISelectionChangedListener fPostSelectionListener;
    private String fWorkingSetLabel;
    private IDialogSettings fDialogSettings;
    private IContextActivation fContextActivation;
    private IPartListener2 fLinkWithEditorListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                ScriptExplorerPart.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                ScriptExplorerPart.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }
    };

    public ScriptExplorerPart() {
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ScriptExplorerPart.this.handlePostSelectionChanged(event);
            }
        };
        this.fDialogSettings = DLTKUIPlugin.getDefault().getDialogSettingsSection(this.getClass().getName());
        this.fShowLibrariesNode = this.fDialogSettings.get(TAG_GROUP_LIBRARIES) == null || this.fDialogSettings.getBoolean(TAG_GROUP_LIBRARIES);
        this.fLinkingEnabled = this.fDialogSettings.getBoolean(TAG_LINK_EDITOR);
        try {
            this.fIsCurrentLayoutFlat = this.fDialogSettings.getInt(TAG_LAYOUT) == 2;
        }
        catch (NumberFormatException numberFormatException) {
            this.fIsCurrentLayoutFlat = this.getDefaultPackageLayout() == 2;
        }
        try {
            this.fRootMode = this.fDialogSettings.getInt(TAG_ROOT_MODE);
        }
        catch (NumberFormatException numberFormatException) {
            this.fRootMode = 1;
        }
    }

    protected int getDefaultPackageLayout() {
        return 1;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String persistedMemento;
        super.init(site, memento);
        if (memento == null && (persistedMemento = this.fDialogSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {}
        }
        this.fMemento = memento;
        if (memento != null) {
            this.restoreLayoutState(memento);
            this.restoreLinkingEnabled(memento);
            this.restoreRootMode(memento);
        }
        if (this.getRootMode() == 2) {
            this.createWorkingSetModel();
        }
    }

    private void restoreRootMode(IMemento memento) {
        Integer value = memento.getInteger(TAG_ROOT_MODE);
        int n = this.fRootMode = value == null ? 1 : value;
        if (this.fRootMode != 1 && this.fRootMode != 2) {
            this.fRootMode = 1;
        }
    }

    private void restoreLayoutState(IMemento memento) {
        Integer groupLibraries;
        Integer layoutState = memento.getInteger(TAG_LAYOUT);
        if (layoutState != null) {
            this.fIsCurrentLayoutFlat = layoutState == 2;
        }
        this.fShowLibrariesNode = (groupLibraries = memento.getInteger(TAG_GROUP_LIBRARIES)) == null || groupLibraries != 0;
    }

    public static ScriptExplorerPart getFromActivePerspective() {
        IWorkbenchPage activePage = DLTKUIPlugin.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(VIEW_ID);
        if (view instanceof ScriptExplorerPart) {
            return (ScriptExplorerPart)view;
        }
        return null;
    }

    public static ScriptExplorerPart openInActivePerspective() {
        try {
            return (ScriptExplorerPart)DLTKUIPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        IContextService ctxService;
        if (this.fContextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.fContextActivation);
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"scriptExplorer");
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this.fDialogSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {}
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fLinkWithEditorListener);
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)this);
        stats.startRun();
        this.fViewer = this.createViewer(parent);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        DLTKUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ScriptExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ScriptExplorerPart.this.fActionSet.handleOpen(event);
                ScriptExplorerPart.this.fLastOpenSelection = event.getSelection();
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        this.setLinkingEnabled(this.isLinkingEnabled());
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext("org.eclipse.dltk.ui.context.views");
        }
        stats.endRun();
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    protected ProblemTreeViewer createViewer(Composite composite) {
        return new PackageExplorerProblemTreeViewer(composite, 770);
    }

    public boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setComparer(this.createElementComparer());
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fDecoratingLabelProvider = new DecoratingModelLabelProvider(this.fLabelProvider, false, this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fDecoratingLabelProvider);
    }

    public void setShowLibrariesNode(boolean enabled) {
        this.fShowLibrariesNode = enabled;
        this.saveDialogSettings();
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    boolean isLibrariesNodeShown() {
        return this.fShowLibrariesNode;
    }

    public void setFlatLayout(boolean enable) {
        this.fIsCurrentLayoutFlat = enable;
        this.saveDialogSettings();
        if (this.fViewer != null) {
            this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
            this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
            this.fDecoratingLabelProvider.setFlatPackageMode(this.isFlatLayout());
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public ScriptExplorerContentProvider createContentProvider() {
        boolean showCUChildren = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.ui.packages.cuchildren");
        if (this.getRootMode() == 1) {
            return new ScriptExplorerContentProvider(showCUChildren){

                @Override
                protected IPreferenceStore getPreferenceStore() {
                    return DLTKUIPlugin.getDefault().getPreferenceStore();
                }
            };
        }
        return new WorkingSetAwareContentProvider(showCUChildren, this.fWorkingSetModel){

            @Override
            protected IPreferenceStore getPreferenceStore() {
                return DLTKUIPlugin.getDefault().getPreferenceStore();
            }
        };
    }

    protected ScriptExplorerLabelProvider createLabelProvider() {
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        return new ScriptExplorerLabelProvider(this.fContentProvider, store);
    }

    protected ScriptExplorerContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    private IElementComparer createElementComparer() {
        if (this.getRootMode() == 1) {
            return null;
        }
        return WorkingSetModel.COMPARER;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private Object findInputElement() {
        if (this.getRootMode() == 2) {
            return this.fWorkingSetModel;
        }
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace) {
            return DLTKCore.create((IWorkspaceRoot)((IWorkspace)input).getRoot());
        }
        if (input instanceof IContainer) {
            IModelElement element = DLTKCore.create((IResource)((IContainer)input));
            if (element != null && element.exists()) {
                return element;
            }
            return input;
        }
        return DLTKCore.create((IWorkspaceRoot)DLTKUIPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class key) {
        if (key.equals(ISelectionProvider.class)) {
            return this.fViewer;
        }
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
        return super.getAdapter(key);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof IScriptModel ? ScriptMessages.PackageExplorerPart_workspace : (element instanceof IModelElement ? ScriptElementLabels.getDefault().getTextLabel(element, ScriptElementLabels.ALL_FULLY_QUALIFIED) : (element instanceof IWorkingSet ? ((IWorkingSet)element).getLabel() : (element instanceof WorkingSetModel ? ScriptMessages.PackageExplorerPart_workingSetModel : this.fLabelProvider.getText(element))))) : ((path = ((IResource)element).getFullPath()).isRoot() ? ScriptMessages.PackageExplorer_title : path.makeRelative().toString());
        if (this.fRootMode == 1) {
            if (this.fWorkingSetLabel == null) {
                return result;
            }
            if (result.length() == 0) {
                return Messages.format(ScriptMessages.PackageExplorer_toolTip, new String[]{this.fWorkingSetLabel});
            }
            return Messages.format(ScriptMessages.PackageExplorer_toolTip2, new String[]{result, this.fWorkingSetLabel});
        }
        if (element != null && !(element instanceof IWorkingSet) && !(element instanceof WorkingSetModel) && this.fActionSet != null) {
            FrameList frameList = this.fActionSet.getFrameList();
            int index = frameList.getCurrentIndex();
            IWorkingSet ws = null;
            while (index >= 0) {
                Object input;
                Frame frame = frameList.getFrame(index);
                if (frame instanceof TreeFrame && (input = ((TreeFrame)frame).getInput()) instanceof IWorkingSet) {
                    ws = (IWorkingSet)input;
                    break;
                }
                --index;
            }
            if (ws != null) {
                return Messages.format(ScriptMessages.PackageExplorer_toolTip3, new String[]{ws.getLabel(), result});
            }
            return result;
        }
        return result;
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager menu) {
        DLTKUIPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_MAKE_ACTIONS, (Object)this);
        stats.startRun();
        this.fActionSet = this.getActionGroup();
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        stats.endRun();
    }

    protected ScriptExplorerActionGroup getActionGroup() {
        return new ScriptExplorerActionGroup(this);
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    protected void initDrag() {
        new DLTKViewerDragSupport((StructuredViewer)this.fViewer).start();
    }

    protected void initDrop() {
        DLTKViewerDropSupport dropSupport = new DLTKViewerDropSupport((StructuredViewer)this.fViewer);
        dropSupport.addDropTargetListener(new WorkingSetDropAdapter(this));
        dropSupport.start();
    }

    private void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.isLinkingEnabled() && !selection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)selection);
        }
        this.fLastOpenSelection = null;
    }

    public void selectReveal(ISelection selection) {
        Control ctrl = this.getTreeViewer().getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        this.fContentProvider.runPendingUpdates();
        this.fViewer.setSelection(this.convertSelection(selection), true);
    }

    public ISelection convertSelection(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return s;
        }
        Object[] elements = ((IStructuredSelection)s).toArray();
        boolean changed = false;
        int i = 0;
        while (i < elements.length) {
            Object convertedElement = this.convertElement(elements[i]);
            changed = changed || convertedElement != elements[i];
            elements[i] = convertedElement;
            ++i;
        }
        if (changed) {
            return new StructuredSelection(elements);
        }
        return s;
    }

    private Object convertElement(Object original) {
        if (original instanceof IModelElement) {
            IResource resource;
            ISourceModule cu;
            IScriptProject javaProject;
            if (original instanceof ISourceModule && (javaProject = (cu = (ISourceModule)original).getScriptProject()) != null && javaProject.exists() && !javaProject.isOnBuildpath((IModelElement)cu) && (resource = cu.getResource()) != null) {
                return resource;
            }
            return original;
        }
        if (original instanceof IResource) {
            IScriptProject javaProject;
            IModelElement je = DLTKCore.create((IResource)((IResource)original));
            if (je != null && je.exists() && (javaProject = je.getScriptProject()) != null && javaProject.exists()) {
                return je;
            }
        } else if (original instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)original;
            IModelElement je2 = (IModelElement)adaptable.getAdapter(IModelElement.class);
            if (je2 != null && je2.exists()) {
                return je2;
            }
            IResource r = (IResource)adaptable.getAdapter(IResource.class);
            if (r != null) {
                je2 = DLTKCore.create((IResource)r);
                if (je2 != null && je2.exists()) {
                    return je2;
                }
                return r;
            }
        }
        return original;
    }

    @Override
    public void selectAndReveal(Object element) {
        this.selectReveal((ISelection)new StructuredSelection(element));
    }

    @Override
    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (!this.isActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IModelElement) {
                EditorUtility.revealInEditor(part, (IModelElement)obj);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null && this.fMemento != null) {
            memento.putMemento(this.fMemento);
            return;
        }
        memento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.saveState(memento);
        }
        this.saveLayoutState(memento);
        this.saveLinkingEnabled(memento);
        if (this.fActionSet != null) {
            this.fActionSet.saveFilterAndSorterState(memento);
        }
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(TAG_LINK_EDITOR, this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
            memento.putInteger(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode ? 1 : 0);
        }
    }

    private void saveDialogSettings() {
        this.fDialogSettings.put(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode);
        this.fDialogSettings.put(TAG_LAYOUT, this.getLayoutAsInt());
        this.fDialogSettings.put(TAG_ROOT_MODE, this.fRootMode);
        this.fDialogSettings.put(TAG_LINK_EDITOR, this.fLinkingEnabled);
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    private void restoreFilterAndSorter() {
        this.setComparator();
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(TAG_LINK_EDITOR);
        this.fLinkingEnabled = val != null && val != 0;
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ScriptExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    protected void editorActivated(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        Object input = this.getInputFromEditor(editorInput);
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editorInput)) {
            this.showInput(input);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private Object getInputFromEditor(IEditorInput editorInput) {
        ISourceModule cu;
        Object input = DLTKUIPlugin.getEditorInputModelElement(editorInput);
        if (input instanceof ISourceModule && !(cu = input).getScriptProject().isOnBuildpath((IModelElement)cu)) {
            input = cu.getResource();
        }
        if (input == null) {
            input = editorInput.getAdapter(IFile.class);
        }
        if (input == null && editorInput instanceof IStorageEditorInput) {
            try {
                input = ((IStorageEditorInput)editorInput).getStorage();
            }
            catch (CoreException coreException) {}
        }
        return input;
    }

    protected boolean inputIsSelected(IEditorInput input) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = EditorUtility.getEditorInput(selection.getFirstElement());
        return input.equals(selectionAsInput);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean showInput(Object input) {
        Object element = null;
        if (input instanceof IFile && this.isOnBuildpath((IFile)input)) {
            element = DLTKCore.create((IFile)((IFile)input));
        }
        if (element == null) {
            element = input;
        }
        if (element == null) return false;
        StructuredSelection newSelection = new StructuredSelection(element);
        if (this.fViewer.getSelection().equals(newSelection)) {
            this.fViewer.reveal(element);
            return true;
        }
        try {
            block10: {
                block9: {
                    this.fViewer.removePostSelectionChangedListener(this.fPostSelectionListener);
                    this.fViewer.setSelection((ISelection)newSelection, true);
                    if (!true) break block9;
                    if (element == null) return true;
                    if (!this.fViewer.getSelection().isEmpty()) break block10;
                }
                do {
                    if ((element = this.getParent(element)) != null) {
                        newSelection = new StructuredSelection(element);
                        this.fViewer.setSelection((ISelection)newSelection, true);
                    }
                    if (element == null) return true;
                } while (this.fViewer.getSelection().isEmpty());
            }
            return true;
        }
        finally {
            this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        }
    }

    private boolean isOnBuildpath(IFile file) {
        IScriptProject jproject = DLTKCore.create((IProject)file.getProject());
        return jproject.isOnBuildpath((IResource)file);
    }

    private Object getParent(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    protected Object getElementOfInput(IEditorInput input) {
        ISourceModule module;
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input instanceof ExternalStorageEditorInput) {
            return ((ExternalStorageEditorInput)input).getStorage();
        }
        if (input instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)input)) != null) {
            return module;
        }
        return null;
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object element) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(element);
    }

    void setWorkingSetLabel(String workingSetName) {
        this.fWorkingSetLabel = workingSetName;
        this.setTitleToolTip(this.getTitleToolTip());
    }

    void updateToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillToolBar(actionBars.getToolBarManager());
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof IScriptModel) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = ScriptElementLabels.getDefault().getTextLabel(input, 564049465049131L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    public void setLabelDecorator(ILabelDecorator decorator) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        boolean refreshViewer = false;
        if ("org.eclipse.dltk.ui.packages.cuchildren".equals(event.getProperty())) {
            this.fActionSet.updateActionBars(this.getViewSite().getActionBars());
            boolean showCUChildren = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.dltk.ui.packages.cuchildren");
            ((StandardModelElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(showCUChildren);
            refreshViewer = true;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add members order preference cach support here...");
        }
        if (refreshViewer) {
            this.fViewer.refresh();
        }
    }

    @Override
    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public boolean show(ShowInContext context) {
        Object input;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                int res = this.tryToReveal(structuredSelection.getFirstElement());
                if (res == 0) {
                    return true;
                }
                if (res == 8) {
                    return false;
                }
            } else if (structuredSelection.size() > 1) {
                this.selectReveal((ISelection)structuredSelection);
                return true;
            }
        }
        if ((input = context.getInput()) instanceof IEditorInput) {
            Object elementOfInput = this.getInputFromEditor((IEditorInput)input);
            return elementOfInput != null && this.tryToReveal(elementOfInput) == 0;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(ScriptExplorerPart.this.getTreeViewer().getInput(), ScriptExplorerPart.this.getTreeViewer().getSelection());
            }
        };
    }

    @Override
    public void setLinkingEnabled(boolean enabled) {
        this.fLinkingEnabled = enabled;
        this.saveDialogSettings();
        IWorkbenchPage page = this.getSite().getPage();
        if (enabled) {
            page.addPartListener(this.fLinkWithEditorListener);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.editorActivated(editor);
            }
        } else {
            page.removePartListener(this.fLinkWithEditorListener);
        }
    }

    String getFrameName(Object element) {
        if (element instanceof IModelElement) {
            return ((IModelElement)element).getElementName();
        }
        if (element instanceof WorkingSetModel) {
            return "";
        }
        return this.fLabelProvider.getText(element);
    }

    public int tryToReveal(Object element) {
        String[] newFilters;
        CustomFiltersActionGroup filterGroup;
        String[] currentFilters;
        if (this.revealElementOrParent(element)) {
            return 0;
        }
        WorkingSetFilterActionGroup workingSetGroup = this.fActionSet.getWorkingSetActionGroup().getFilterGroup();
        if (workingSetGroup != null) {
            IWorkingSet workingSet = workingSetGroup.getWorkingSet();
            if (workingSetGroup.isFiltered(this.getVisibleParent(element), element)) {
                String message;
                if (element instanceof IModelElement) {
                    IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)element);
                    ScriptElementLabels labels = toolkit.getScriptElementLabels();
                    String elementLabel = labels.getElementLabel((IModelElement)element, ScriptElementLabels.ALL_DEFAULT);
                    message = Messages.format(ScriptMessages.PackageExplorer_notFound, new String[]{elementLabel, workingSet.getLabel()});
                } else {
                    message = Messages.format(ScriptMessages.PackageExplorer_notFound, workingSet.getLabel());
                }
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ScriptMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                    workingSetGroup.setWorkingSet(null, true);
                    if (this.revealElementOrParent(element)) {
                        return 0;
                    }
                } else {
                    return 8;
                }
            }
        }
        if ((currentFilters = (filterGroup = this.fActionSet.getCustomFilterActionGroup()).internalGetEnabledFilterIds()).length > (newFilters = filterGroup.removeFiltersFor(this.getVisibleParent(element), element, this.getTreeViewer().getContentProvider())).length) {
            String message;
            if (element instanceof IModelElement) {
                IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit((IModelElement)element);
                ScriptElementLabels labels = toolkit.getScriptElementLabels();
                String elementLabel = labels.getElementLabel((IModelElement)element, ScriptElementLabels.ALL_DEFAULT);
                message = Messages.format(ScriptMessages.PackageExplorer_removeFilters, elementLabel);
            } else {
                message = ScriptMessages.PackageExplorer_removeFilters;
            }
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ScriptMessages.PackageExplorer_filteredDialog_title, (String)message)) {
                filterGroup.setFilters(newFilters);
                if (this.revealElementOrParent(element)) {
                    return 0;
                }
            } else {
                return 8;
            }
        }
        FrameAction action = this.fActionSet.getUpAction();
        while (action.getFrameList().getCurrentIndex() > 0) {
            if (action.getFrameList().getSource().getFrame(3, 0) == null) break;
            action.run();
            if (!this.revealElementOrParent(element)) continue;
            return 0;
        }
        return 4;
    }

    private boolean revealElementOrParent(Object element) {
        if (this.revealAndVerify(element)) {
            return true;
        }
        if ((element = this.getVisibleParent(element)) != null) {
            IResource resource;
            if (this.revealAndVerify(element)) {
                return true;
            }
            if (element instanceof IModelElement && (resource = ((IModelElement)element).getResource()) != null && this.revealAndVerify(resource)) {
                return true;
            }
        }
        return false;
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IModelElement)) {
            return object;
        }
        IModelElement element2 = (IModelElement)object;
        switch (element2.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                element2 = element2.getOpenable();
                break;
            }
            case 1: {
                element2 = null;
            }
        }
        return element2;
    }

    private boolean revealAndVerify(Object element) {
        if (element == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(element));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        this.saveDialogSettings();
        if (this.getRootMode() == 2 && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        StructuredSelection selection = new StructuredSelection(((IStructuredSelection)this.fViewer.getSelection()).toArray());
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (isRootInputChange) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setComparator();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (isRootInputChange) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection((ISelection)selection, true);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
        if (isRootInputChange && this.getRootMode() == 2 && this.fWorkingSetModel.needsConfiguration()) {
            this.configWorkingSet();
            this.fWorkingSetModel.configured();
        }
        this.setTitleToolTip(this.getTitleToolTip());
    }

    protected void configWorkingSet() {
        ConfigureWorkingSetAction action = new ConfigureWorkingSetAction(this.getSite());
        action.setWorkingSetModel(this.fWorkingSetModel);
        action.run();
    }

    private void createWorkingSetModel() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                ScriptExplorerPart.this.fWorkingSetModel = new WorkingSetModel(ScriptExplorerPart.this.fMemento);
            }

            public void handleException(Throwable exception) {
                ScriptExplorerPart.this.fWorkingSetModel = new WorkingSetModel(null);
            }
        });
    }

    public IWorkingSet getFilterWorkingSet() {
        if (this.getRootMode() != 1) {
            return null;
        }
        if (this.fActionSet == null) {
            return null;
        }
        return this.fActionSet.getWorkingSetActionGroup().getFilterGroup().getWorkingSet();
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    protected boolean showProjects() {
        return this.fRootMode == 1;
    }

    protected boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    protected void setComparator() {
        if (this.showWorkingSets()) {
            WorkingSetAwareModelElementSorter comparator = new WorkingSetAwareModelElementSorter();
            comparator.setInnerElements(false);
            this.fViewer.setComparator((ViewerComparator)comparator);
        } else {
            ModelElementSorter comparator = new ModelElementSorter();
            comparator.setInnerElements(false);
            this.fViewer.setComparator((ViewerComparator)comparator);
        }
    }

    public void internalTestShowWorkingSets(IWorkingSet[] workingSets) {
        if (this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
        }
        this.fWorkingSetModel.setActiveWorkingSets(workingSets);
        this.fWorkingSetModel.configured();
        this.rootModeChanged(2);
    }

    protected class PackageExplorerProblemTreeViewer
    extends ProblemTreeViewer {
        private List fPendingRefreshes;
        private boolean fInPreserveSelection;

        public PackageExplorerProblemTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.fPendingRefreshes = Collections.synchronizedList(new ArrayList());
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingRefreshes.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        protected void internalRefresh(Object element, boolean updateLabels) {
            try {
                this.fPendingRefreshes.add(element);
                super.internalRefresh(element, updateLabels);
            }
            finally {
                this.fPendingRefreshes.remove(element);
            }
        }

        @Override
        protected boolean evaluateExpandableWithFilters(Object parent) {
            if (parent instanceof IScriptProject || parent instanceof ISourceModule || parent instanceof BuildPathContainer) {
                return false;
            }
            return !(parent instanceof IProjectFragment) || !((IProjectFragment)parent).isArchive();
        }

        @Override
        protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
            boolean res = super.isFiltered(object, parent, filters);
            if (res && this.isEssential(object)) {
                return false;
            }
            return res;
        }

        private boolean isEssential(Object object) {
            try {
                IScriptFolder fragment;
                if (!ScriptExplorerPart.this.isFlatLayout() && object instanceof IScriptFolder && !(fragment = (IScriptFolder)object).isRootFolder() && fragment.hasSubfolders()) {
                    return this.hasFilteredChildren(fragment);
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            return false;
        }

        @Override
        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<Object>();
            boolean changed = false;
            for (Object element : is) {
                IProject project;
                if (element instanceof IScriptProject) {
                    project = ((IScriptProject)element).getProject();
                    if (project.isOpen() || !project.exists()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                IScriptProject jProject = DLTKCore.create((IProject)project);
                if (jProject != null && jProject.exists()) {
                    ns.add(jProject);
                }
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }

        @Override
        protected Object[] addAditionalProblemParents(Object[] elements) {
            if (ScriptExplorerPart.this.getRootMode() == 2 && elements != null) {
                return ScriptExplorerPart.this.fWorkingSetModel.addWorkingSets(elements);
            }
            return elements;
        }

        protected void preservingSelection(Runnable updateCode) {
            try {
                this.fInPreserveSelection = true;
                super.preservingSelection(updateCode);
            }
            finally {
                this.fInPreserveSelection = false;
            }
        }

        protected void setSelectionToWidget(ISelection selection, boolean reveal) {
            super.setSelectionToWidget(selection, reveal);
        }

        private Widget internalFindChild(Widget parent, Object element) {
            Item[] items = this.getChildren(parent);
            int i = 0;
            while (i < items.length) {
                Item item = items[i];
                Object data = item.getData();
                if (data != null && this.equals(data, element)) {
                    return item;
                }
                ++i;
            }
            return null;
        }

        private CustomHashtable createRootAccessedMap(TreePath[] paths) {
            CustomHashtable result = new CustomHashtable(this.getComparer());
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                Object root = path.getFirstSegment();
                if (root != null) {
                    result.put(root, path);
                }
                ++i;
            }
            return result;
        }
    }
}

