/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InstrumentationMode implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    SOURCES(1, "SOURCES", "SOURCES"),
    SELECTION(2, "SELECTION", "SELECTION");

    public static final int DEFAULT_VALUE = 0;
    public static final int SOURCES_VALUE = 1;
    public static final int SELECTION_VALUE = 2;
    private static final InstrumentationMode[] VALUES_ARRAY;
    public static final List<InstrumentationMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new InstrumentationMode[]{DEFAULT, SOURCES, SELECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static InstrumentationMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InstrumentationMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InstrumentationMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InstrumentationMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InstrumentationMode get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return SOURCES;
            }
            case 2: {
                return SELECTION;
            }
        }
        return null;
    }

    private InstrumentationMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

