/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.UnaryExpression;

public class OperatorPrecedence {
    public static final int SEQUENCE = 0;
    public static final int ASSIGNMENT = 1;
    public static final int CONDITIONAL = 2;
    public static final int LOGICAL_OR = 3;
    public static final int LOGICAL_AND = 4;
    public static final int BITWISE_OR = 5;
    public static final int BITWISE_XOR = 6;
    public static final int BITWISE_AND = 7;
    public static final int EQUALITY = 8;
    public static final int RELATIONAL = 9;
    public static final int SHIFT = 10;
    public static final int ADDITIVE = 11;
    public static final int MULTIPLICATIVE = 12;
    public static final int PREFIX = 14;
    public static final int POSTFIX = 15;
    public static final int INSTANTIATION = 16;
    public static final int CALL = 17;

    public static int getExpressionPrecedence(Expression expression) {
        switch (expression.eClass().getClassifierID()) {
            case 28: {
                switch (((BinaryExpression)expression).getOperation()) {
                    case COMMA: {
                        return 0;
                    }
                    case LOG_OR: {
                        return 3;
                    }
                    case LOG_AND: {
                        return 4;
                    }
                    case BW_OR: {
                        return 5;
                    }
                    case BW_XOR: {
                        return 6;
                    }
                    case BW_AND: {
                        return 7;
                    }
                    case EQ: 
                    case NEQ: 
                    case SAME: 
                    case NSAME: {
                        return 8;
                    }
                    case LESS: 
                    case GREATER: 
                    case LEQ: 
                    case GEQ: 
                    case INSTANCEOF: 
                    case IN: {
                        return 9;
                    }
                    case LSH: 
                    case RSH: 
                    case URSH: {
                        return 10;
                    }
                    case ADD: 
                    case SUB: {
                        return 11;
                    }
                    case MUL: 
                    case DIV: 
                    case MOD: {
                        return 12;
                    }
                }
                return 1;
            }
            case 29: {
                return 2;
            }
            case 27: {
                switch (((UnaryExpression)expression).getOperation()) {
                    case POSTFIX_INC: 
                    case POSTFIX_DEC: {
                        return 15;
                    }
                }
                return 14;
            }
            case 25: {
                return 16;
            }
            case 23: 
            case 24: 
            case 26: {
                return 17;
            }
        }
        return Integer.MAX_VALUE;
    }
}

