/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.PositionInformation;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.python.parser.ast.expressions.PythonTestListExpression;
import org.eclipse.dltk.python.parser.ast.statements.SimpleStatement;
import org.eclipse.dltk.utils.CorePrinter;

public class PythonImportStatement
extends SimpleStatement {
    public PythonImportStatement(DLTKToken t, Expression expression) {
        super(t, expression);
    }

    public int getKind() {
        return 37003;
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("import ");
        if (this.fExpression != null) {
            this.fExpression.printNode(output);
        }
    }

    public List getImports() {
        Expression imexpr = this.getExpression();
        List<Object> imports = new ArrayList<Expression>();
        if (imexpr instanceof PythonTestListExpression) {
            PythonTestListExpression testList = (PythonTestListExpression)imexpr;
            imports = testList.getExpressions();
        } else {
            imports.add(imexpr);
        }
        return imports;
    }

    public PositionInformation getPosition() {
        int start = this.sourceStart();
        int end = this.sourceEnd();
        return new PositionInformation(start, end, start, end);
    }
}

