/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.dltk.internal.corext.refactoring.base.ScriptStatusContext;
import org.eclipse.dltk.internal.corext.util.SearchUtils;
import org.eclipse.dltk.internal.javascript.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.javascript.core.JavaScriptLanguageToolkit;
import org.eclipse.dltk.javascript.core.dom.CallExpression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.Source;
import org.eclipse.dltk.javascript.core.dom.rewrite.ASTConverter;
import org.eclipse.dltk.javascript.core.dom.rewrite.NodeFinder;
import org.eclipse.dltk.javascript.core.dom.rewrite.RefactoringUtils;
import org.eclipse.dltk.javascript.parser.JavaScriptParserUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

abstract class TargetProvider {
    TargetProvider() {
    }

    public abstract List<ISourceModule> getAffectedSourceModules(RefactoringStatus var1, IProgressMonitor var2) throws CoreException;

    public abstract Source getRoot(ISourceModule var1);

    public abstract Node[] getAffectedBodyDeclarations(ISourceModule var1, IProgressMonitor var2);

    public abstract CallExpression[] getInvocations(Node var1, IProgressMonitor var2);

    public abstract int getStatusSeverity();

    public static TargetProvider create(IMethod method) {
        return new MemberTypeTargetProvider(method);
    }

    public static TargetProvider create(ISourceModule cu, int offset, int length) {
        return new SingleCallTargetProvider(cu, offset, length);
    }

    static void fastDone(IProgressMonitor pm) {
        if (pm == null) {
            return;
        }
        pm.beginTask("", 1);
        pm.worked(1);
        pm.done();
    }

    private static class MemberTypeTargetProvider
    extends TargetProvider {
        private final IMethod method;
        private final Map<ISourceModule, Source> roots = new HashMap<ISourceModule, Source>();
        private Map<ISourceModule, List<SearchMatch>> calls;
        private Map<Node, List<CallExpression>> currentBodies;

        public MemberTypeTargetProvider(IMethod method) {
            Assert.isNotNull((Object)method);
            this.method = method;
        }

        @Override
        public List<ISourceModule> getAffectedSourceModules(final RefactoringStatus status, IProgressMonitor pm) throws CoreException {
            SearchPattern pattern = SearchPattern.createPattern((IModelElement)this.method, (int)1, (int)24, (IDLTKLanguageToolkit)JavaScriptLanguageToolkit.getDefault());
            IDLTKSearchScope scope = RefactoringScopeFactory.create((IModelElement)this.method, (boolean)true, (boolean)false);
            if (this.calls == null) {
                this.calls = new HashMap<ISourceModule, List<SearchMatch>>();
                CollectingSearchRequestor requestor = new CollectingSearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        if (this.filterMatch(match)) {
                            return;
                        }
                        if (match.isInsideDocComment()) {
                            return;
                        }
                        ISourceModule unit = SearchUtils.getSourceModule((SearchMatch)match);
                        if (match.getAccuracy() == 1) {
                            if (unit != null) {
                                status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match, ScriptStatusContext.create((ISourceModule)unit, (ISourceRange)new SourceRange(match.getOffset(), match.getLength())));
                            } else {
                                status.addError(RefactoringCoreMessages.TargetProvider_inaccurate_match);
                            }
                        } else if (unit != null) {
                            ArrayList<SearchMatch> list = (ArrayList<SearchMatch>)MemberTypeTargetProvider.this.calls.get(unit);
                            if (list == null) {
                                list = new ArrayList<SearchMatch>();
                                MemberTypeTargetProvider.this.calls.put(unit, list);
                            }
                            list.add(match);
                        }
                    }
                };
                new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            return new ArrayList<ISourceModule>(this.calls.keySet());
        }

        @Override
        public Source getRoot(ISourceModule unit) {
            Source root = this.roots.get(unit);
            if (root == null) {
                root = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)unit));
                this.roots.put(unit, root);
            }
            return root;
        }

        @Override
        public Node[] getAffectedBodyDeclarations(ISourceModule unit, IProgressMonitor pm) {
            Source root = this.roots.get(unit);
            this.currentBodies = new HashMap<Node, List<CallExpression>>();
            Node[] nodeArray = NodeFinder.findNodes(root, (Iterable<SearchMatch>)this.calls.get(unit));
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                CallExpression expr = RefactoringUtils.getFunctionReference(node);
                if (expr != null) {
                    Node enclosing = NodeFinder.findEnclosingNode(expr);
                    List<CallExpression> list = this.currentBodies.get(enclosing);
                    if (list == null) {
                        list = new ArrayList<CallExpression>();
                        this.currentBodies.put(enclosing, list);
                    }
                    list.add(expr);
                }
                ++n2;
            }
            Set<Node> result = this.currentBodies.keySet();
            MemberTypeTargetProvider.fastDone(pm);
            return result.toArray(new Node[result.size()]);
        }

        @Override
        public CallExpression[] getInvocations(Node declaration, IProgressMonitor pm) {
            List<CallExpression> list = this.currentBodies.get(declaration);
            return list.toArray(new CallExpression[list.size()]);
        }

        @Override
        public int getStatusSeverity() {
            return 3;
        }
    }

    static class SingleCallTargetProvider
    extends TargetProvider {
        private ISourceModule cu;
        private Source root;
        private CallExpression invocation;

        public SingleCallTargetProvider(ISourceModule cu, int offset, int length) {
            this.cu = cu;
            this.root = (Source)ASTConverter.convert((ASTNode)JavaScriptParserUtil.parse((ISourceModule)cu));
            this.invocation = RefactoringUtils.getFunctionReference(NodeFinder.findNode(this.root, offset, offset + length));
        }

        @Override
        public List<ISourceModule> getAffectedSourceModules(RefactoringStatus status, IProgressMonitor pm) {
            ArrayList<ISourceModule> res = new ArrayList<ISourceModule>(1);
            res.add(this.cu);
            return res;
        }

        @Override
        public Source getRoot(ISourceModule unit) {
            Assert.isTrue((unit == this.cu ? 1 : 0) != 0);
            return this.root;
        }

        @Override
        public Node[] getAffectedBodyDeclarations(ISourceModule unit, IProgressMonitor pm) {
            Assert.isTrue((unit == this.cu ? 1 : 0) != 0);
            SingleCallTargetProvider.fastDone(pm);
            return new Node[]{NodeFinder.findEnclosingNode(this.invocation)};
        }

        @Override
        public CallExpression[] getInvocations(Node declaration, IProgressMonitor pm) {
            SingleCallTargetProvider.fastDone(pm);
            return new CallExpression[]{this.invocation};
        }

        @Override
        public int getStatusSeverity() {
            return 4;
        }
    }
}

