/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.semantic.highlighting;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.internal.ui.coloring.AbstractColoringPreferenceRequestor;
import org.eclipse.dltk.ui.coloring.ColoringPreferences;
import org.eclipse.dltk.ui.coloring.EnablementStyle;
import org.eclipse.dltk.ui.coloring.FontStyle;
import org.eclipse.dltk.ui.coloring.IColoringPreferenceKey;
import org.eclipse.dltk.ui.coloring.IColoringPreferenceProvider;
import org.eclipse.dltk.ui.editor.highlighting.AbortSemanticHighlightingException;
import org.eclipse.dltk.ui.editor.highlighting.AbstractSemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlighterExtension;
import org.eclipse.dltk.ui.editor.highlighting.SemanticHighlighting;
import org.eclipse.swt.graphics.RGB;

public class ContributedSemanticHighlighter
extends AbstractSemanticHighlighter {
    private final String natureId;
    private final ISemanticHighlighter[] highlighters;
    private boolean initialized = false;
    private final Map<String, SemanticHighlighting> highlightings = new HashMap<String, SemanticHighlighting>();

    public ContributedSemanticHighlighter(String natureId, ISemanticHighlighter[] highlighters) {
        this.natureId = natureId;
        this.highlighters = highlighters;
    }

    @Override
    protected boolean doHighlighting(IModuleSource code) throws Exception {
        ISemanticHighlighter[] iSemanticHighlighterArray = this.highlighters;
        int n = this.highlighters.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticHighlighter highlighter = iSemanticHighlighterArray[n2];
            try {
                highlighter.process(code, this);
            }
            catch (AbortSemanticHighlightingException abortSemanticHighlightingException) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public SemanticHighlighting[] getSemanticHighlightings() {
        if (!this.initialized) {
            int n;
            this.initialized = true;
            ISemanticHighlighter[] iSemanticHighlighterArray = this.highlighters;
            int n2 = this.highlighters.length;
            int n3 = 0;
            while (n3 < n2) {
                SemanticHighlighting[] hls;
                ISemanticHighlighter highlighter = iSemanticHighlighterArray[n3];
                if (highlighter instanceof ISemanticHighlighterExtension && (hls = ((ISemanticHighlighterExtension)((Object)highlighter)).getSemanticHighlightings()) != null) {
                    SemanticHighlighting[] semanticHighlightingArray = hls;
                    n = hls.length;
                    int n4 = 0;
                    while (n4 < n) {
                        SemanticHighlighting hl = semanticHighlightingArray[n4];
                        this.highlightings.put(hl.getPreferenceKey(), hl);
                        ++n4;
                    }
                }
                ++n3;
            }
            Map<String, SemanticHighlighting> all = null;
            ISemanticHighlighter[] iSemanticHighlighterArray2 = this.highlighters;
            int n5 = this.highlighters.length;
            n2 = 0;
            while (n2 < n5) {
                ISemanticHighlighter highlighter = iSemanticHighlighterArray2[n2];
                String[] hls = highlighter.getHighlightingKeys();
                if (hls != null) {
                    String[] stringArray = hls;
                    int n6 = hls.length;
                    n = 0;
                    while (n < n6) {
                        String hl = stringArray[n];
                        if (!this.highlightings.containsKey(hl)) {
                            SemanticHighlighting h;
                            if (all == null) {
                                SemanticHighlightingCollector collector = new SemanticHighlightingCollector();
                                IColoringPreferenceProvider[] providers = ColoringPreferences.getProviders(this.natureId);
                                if (providers != null) {
                                    IColoringPreferenceProvider[] iColoringPreferenceProviderArray = providers;
                                    int n7 = providers.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        IColoringPreferenceProvider provider = iColoringPreferenceProviderArray[n8];
                                        provider.providePreferences(collector);
                                        ++n8;
                                    }
                                }
                                all = collector.map;
                            }
                            if ((h = (SemanticHighlighting)all.get(hl)) != null) {
                                this.highlightings.put(hl, h);
                            }
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        }
        return this.highlightings.values().toArray(new SemanticHighlighting[this.highlightings.size()]);
    }

    private static class SemanticHighlightingCollector
    extends AbstractColoringPreferenceRequestor {
        final Map<String, SemanticHighlighting> map = new HashMap<String, SemanticHighlighting>();

        private SemanticHighlightingCollector() {
        }

        @Override
        public void addPreference(IColoringPreferenceKey key, String name, RGB color, EnablementStyle enablementStyle, FontStyle ... fontStyles) {
            this.map.put(key.getColorKey(), new StdSemanticHighlighting(key, enablementStyle));
        }
    }

    private static class StdSemanticHighlighting
    extends SemanticHighlighting {
        final IColoringPreferenceKey key;
        final EnablementStyle enablementStyle;

        public StdSemanticHighlighting(IColoringPreferenceKey key, EnablementStyle enablementStyle) {
            this.key = key;
            this.enablementStyle = enablementStyle;
        }

        @Override
        public String getPreferenceKey() {
            return this.key.getColorKey();
        }

        @Override
        public boolean isSemanticOnly() {
            return this.enablementStyle != EnablementStyle.ALWAYS_ON;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "(" + this.key + "," + (Object)((Object)this.enablementStyle) + ")";
        }
    }
}

