/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import java.util.HashMap;
import org.eclipse.dltk.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.dbgp.internal.packets.Messages;

public final class DbgpResponcePacketWaiter {
    private static final int MIN_TIMEOUT = 5;
    private final HashMap map = new HashMap();
    private boolean terminated = false;

    public synchronized void put(DbgpResponsePacket packet) {
        int id = packet.getTransactionId();
        this.map.put(new Integer(id), packet);
        this.notifyAll();
    }

    public synchronized DbgpResponsePacket waitPacket(int id, int timeout) throws InterruptedException {
        Integer key = new Integer(id);
        long endTime = 0L;
        if (timeout > 0) {
            endTime = System.currentTimeMillis() + (long)timeout;
        }
        while (!this.terminated && !this.map.containsKey(key)) {
            long current = System.currentTimeMillis();
            if (endTime != 0L && current >= endTime) break;
            if (endTime == 0L) {
                this.wait();
                continue;
            }
            this.wait(endTime - current);
        }
        if (this.map.containsKey(key)) {
            return (DbgpResponsePacket)this.map.remove(key);
        }
        if (this.terminated) {
            throw new InterruptedException(Messages.DbgpPacketReceiver_responsePacketWaiterTerminated);
        }
        return null;
    }

    public synchronized void terminate() {
        this.terminated = true;
        this.notifyAll();
    }
}

