/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.javascript.typeinfo.CommonSuperTypeFinder;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.GenericMethod;
import org.eclipse.dltk.javascript.typeinfo.model.GenericType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariable;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableClassType;
import org.eclipse.dltk.javascript.typeinfo.model.TypeVariableReference;
import org.eclipse.dltk.javascript.typeinfo.model.UnionType;
import org.eclipse.emf.common.util.EList;

public class GenericMethodTypeInferencer
implements ITypeSystem {
    private final ITypeSystem typeSystem;
    private final Map<TypeVariable, JSTypeSet> captures = new HashMap<TypeVariable, JSTypeSet>();
    private final Map<TypeVariable, IRType> evaluated = new HashMap<TypeVariable, IRType>();
    private static final int SIMPLE_WEIGHT = 0;
    private static final int CLASS_WEIGHT = 10;

    public GenericMethodTypeInferencer(ITypeSystem typeSystem, GenericMethod method) {
        this.typeSystem = typeSystem;
        for (TypeVariable variable : method.getTypeParameters()) {
            this.captures.put(variable, JSTypeSet.create());
        }
    }

    @Nullable
    public Capture capture(JSType paramType, Iterable<? extends IRType> argTypes) {
        Capture capture = this.doCapture(paramType, argTypes);
        if (capture != null) {
            for (TypeVariable variable : capture.getVariables()) {
                JSTypeSet variableTypes = this.captures.get(variable);
                if (variableTypes == null) continue;
                variableTypes.addAll(capture.getTypeOf(variable));
                this.evaluated.remove(variable);
            }
        }
        return capture;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private Capture doCapture(JSType paramType, Iterable<? extends IRType> argTypes) {
        if (paramType instanceof TypeVariableReference) {
            return this.capture(((TypeVariableReference)paramType).getVariable(), argTypes, 0);
        }
        if (paramType instanceof TypeVariableClassType) {
            JSTypeSet result = JSTypeSet.create();
            for (IRType iRType : argTypes) {
                if (!(iRType instanceof IRClassType)) continue;
                result.add(((IRClassType)iRType).toItemType());
            }
            return !result.isEmpty() ? this.capture(((TypeVariableClassType)paramType).getVariable(), result, 10) : null;
        }
        if (paramType instanceof ArrayType) {
            JSTypeSet result = JSTypeSet.create();
            for (IRType iRType : argTypes) {
                if (!(iRType instanceof IRArrayType)) continue;
                result.add(((IRArrayType)iRType).getItemType());
            }
            return !result.isEmpty() ? this.doCapture(((ArrayType)paramType).getItemType(), result) : null;
        }
        if (paramType instanceof MapType) {
            MapType mapType = (MapType)paramType;
            JSTypeSet jSTypeSet = JSTypeSet.create();
            JSTypeSet values = JSTypeSet.create();
            for (IRType iRType : argTypes) {
                if (!(iRType instanceof IRMapType)) continue;
                IRMapType arg = (IRMapType)iRType;
                if (arg.getKeyType() != null) {
                    jSTypeSet.add(arg.getKeyType());
                }
                values.add(arg.getValueType());
            }
            Capture capture = mapType.getKeyType() != null && !jSTypeSet.isEmpty() ? this.doCapture(mapType.getKeyType(), jSTypeSet) : null;
            Capture capture2 = mapType.getValueType() != null && !values.isEmpty() ? this.doCapture(mapType.getValueType(), values) : null;
            return this.merge(capture, capture2);
        }
        if (paramType instanceof ParameterizedType) {
            void var6_26;
            ParameterizedType parameterized = (ParameterizedType)paramType;
            int n = parameterized.getActualTypeArguments().size();
            JSTypeSet[] typeParams = new JSTypeSet[n];
            boolean bl = false;
            while (var6_26 < n) {
                typeParams[var6_26] = JSTypeSet.create();
                ++var6_26;
            }
            Type type = this.typeSystem.resolveType(parameterized.getTarget());
            for (IRType iRType : argTypes) {
                int i;
                IRTypeDeclaration declaration;
                if (!(iRType instanceof IRSimpleType) || !type.equals((declaration = ((IRSimpleType)iRType).getDeclaration()).getSource())) continue;
                if (declaration.isParameterized()) {
                    int effectiveParamCount = Math.min(n, declaration.getActualTypeArguments().size());
                    i = 0;
                    while (i < effectiveParamCount) {
                        typeParams[i].add(declaration.getActualTypeArguments().get(i));
                        ++i;
                    }
                    continue;
                }
                if (!(type instanceof GenericType)) continue;
                EList<TypeVariable> typeParameters = ((GenericType)type).getTypeParameters();
                i = 0;
                while (i < n) {
                    if (i < typeParameters.size() && ((TypeVariable)typeParameters.get(i)).getBound() != null) {
                        typeParams[i].add(RTypes.create(this.typeSystem, ((TypeVariable)typeParameters.get(i)).getBound()));
                    }
                    ++i;
                }
            }
            Capture[] captureArray = new Capture[n];
            int i = 0;
            while (i < n) {
                captureArray[i] = this.doCapture((JSType)parameterized.getActualTypeArguments().get(i), typeParams[i]);
                ++i;
            }
            return this.merge(captureArray);
        }
        if (paramType instanceof UnionType) {
            AbstractCapture bestCapture = null;
            for (JSType jSType : ((UnionType)paramType).getTargets()) {
                Capture capture = this.doCapture(jSType, argTypes);
                if (!(capture instanceof AbstractCapture)) continue;
                AbstractCapture abstractCapture = (AbstractCapture)capture;
                if (bestCapture != null && abstractCapture.weight <= bestCapture.weight) continue;
                bestCapture = abstractCapture;
            }
            return bestCapture;
        }
        return null;
    }

    private Capture merge(Capture ... captures) {
        int errors = 0;
        HashMap<TypeVariable, TempCapture> variables = new HashMap<TypeVariable, TempCapture>();
        Capture[] captureArray = captures;
        int n = captures.length;
        int n2 = 0;
        while (n2 < n) {
            Capture capture = captureArray[n2];
            if (capture != null) {
                if (capture == ErrorCapture.ERROR) {
                    ++errors;
                } else if (capture instanceof AbstractCapture) {
                    AbstractCapture ac = (AbstractCapture)capture;
                    for (TypeVariable variable : capture.getVariables()) {
                        TempCapture temp = (TempCapture)variables.get(variable);
                        if (temp == null) {
                            temp = new TempCapture();
                            temp.weight = ac.weight;
                            variables.put(variable, temp);
                        } else if (ac.weight > temp.weight) {
                            temp.weight = ac.weight;
                            temp.types.clear();
                        }
                        temp.types.addAll(capture.getTypeOf(variable));
                    }
                }
            }
            ++n2;
        }
        if (variables.isEmpty()) {
            return errors != 0 ? ErrorCapture.ERROR : null;
        }
        if (variables.size() == 1) {
            Map.Entry entry = variables.entrySet().iterator().next();
            return new SingleCapture((TypeVariable)entry.getKey(), ((TempCapture)entry.getValue()).types, ((TempCapture)entry.getValue()).weight);
        }
        int weight = Integer.MAX_VALUE;
        HashMap<TypeVariable, JSTypeSet> multiCaptures = new HashMap<TypeVariable, JSTypeSet>();
        for (Map.Entry entry : variables.entrySet()) {
            if (((TempCapture)entry.getValue()).weight < weight) {
                weight = ((TempCapture)entry.getValue()).weight;
            }
            multiCaptures.put((TypeVariable)entry.getKey(), ((TempCapture)entry.getValue()).types);
        }
        return new MultiCapture(multiCaptures, weight);
    }

    @Nullable
    private Capture capture(TypeVariable variable, Iterable<? extends IRType> argTypes, int weight) {
        return this.captures.containsKey(variable) ? new SingleCapture(variable, argTypes, weight) : null;
    }

    @Override
    public IRType getTypeVariable(TypeVariable variable) {
        IRType type = this.evaluated.get(variable);
        if (type != null) {
            return type;
        }
        JSTypeSet types = this.captures.get(variable);
        if (types != null) {
            if (types.size() > 1) {
                ArrayList<IRType> copy = new ArrayList<IRType>(types.size());
                for (IRType t : types) {
                    copy.add(t);
                }
                type = CommonSuperTypeFinder.evaluate(this.typeSystem, copy);
            } else {
                type = types.toRType();
            }
            if (type == null) {
                type = RTypes.none();
            }
            this.evaluated.put(variable, type);
            return type;
        }
        return null;
    }

    @Override
    public Type getKnownType(String typeName) {
        return this.typeSystem.getKnownType(typeName);
    }

    @Override
    public Type resolveType(Type type) {
        return this.typeSystem.resolveType(type);
    }

    @Override
    public IValue valueOf(IRMember member) {
        return this.typeSystem.valueOf(member);
    }

    @Override
    public IRTypeDeclaration convert(Type type) {
        return this.typeSystem.convert(type);
    }

    @Override
    public <E extends IRMember> E contextualize(E member, IRTypeDeclaration type) {
        return this.typeSystem.contextualize(member, type);
    }

    @Override
    public IRTypeDeclaration parameterize(Type target, List<? extends IRType> parameters) {
        return this.typeSystem.parameterize(target, parameters);
    }

    @Override
    public Object getValue(Object key) {
        return this.typeSystem.getValue(key);
    }

    @Override
    public void setValue(Object key, Object value) {
        this.typeSystem.setValue(key, value);
    }

    @Override
    public ITypeSystem getPrimary() {
        return this.typeSystem;
    }

    private static abstract class AbstractCapture
    implements Capture {
        final int weight;

        public AbstractCapture(int weight) {
            this.weight = weight;
        }

        @Override
        public boolean isOK() {
            return true;
        }
    }

    public static interface Capture {
        public boolean isOK();

        public Collection<TypeVariable> getVariables();

        public JSTypeSet getTypeOf(TypeVariable var1);
    }

    private static enum ErrorCapture implements Capture
    {
        ERROR;


        @Override
        public boolean isOK() {
            return false;
        }

        @Override
        public Collection<TypeVariable> getVariables() {
            return Collections.emptyList();
        }

        @Override
        public JSTypeSet getTypeOf(TypeVariable variable) {
            return JSTypeSet.emptySet();
        }
    }

    private static class MultiCapture
    extends AbstractCapture {
        private final Map<TypeVariable, JSTypeSet> captures;

        public MultiCapture(Map<TypeVariable, JSTypeSet> captures, int weight) {
            super(weight);
            this.captures = captures;
        }

        @Override
        public Collection<TypeVariable> getVariables() {
            return this.captures.keySet();
        }

        @Override
        public JSTypeSet getTypeOf(TypeVariable variable) {
            return this.captures.get(variable);
        }

        public String toString() {
            return this.captures.toString();
        }
    }

    private static class SingleCapture
    extends AbstractCapture {
        private final TypeVariable variable;
        private final Iterable<? extends IRType> types;

        public SingleCapture(TypeVariable variable, Iterable<? extends IRType> types, int weight) {
            super(weight);
            this.variable = variable;
            this.types = types;
        }

        @Override
        public Collection<TypeVariable> getVariables() {
            return Collections.singletonList(this.variable);
        }

        @Override
        public JSTypeSet getTypeOf(TypeVariable variable) {
            return this.variable.equals(variable) ? JSTypeSet.of(this.types) : null;
        }

        public String toString() {
            return this.variable + "=" + this.types;
        }
    }

    static class TempCapture {
        final JSTypeSet types = JSTypeSet.create();
        int weight;

        TempCapture() {
        }
    }
}

