/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.UserLibrary;
import org.eclipse.dltk.internal.core.UserLibraryBuildpathContainer;
import org.eclipse.dltk.internal.core.util.Util;
import org.osgi.service.prefs.BackingStoreException;

public class UserLibraryManager {
    public static final String BP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.dltk.core.userLibrary.";
    private Map userLibraries;

    public UserLibraryManager() {
        this.initialize();
    }

    public synchronized UserLibrary getUserLibrary(String libName, IDLTKLanguageToolkit toolkit) {
        return (UserLibrary)this.userLibraries.get(UserLibraryManager.makeLibraryName(libName, toolkit));
    }

    public static String makeLibraryName(String libName, IDLTKLanguageToolkit toolkit) {
        if (toolkit == null) {
            return "#" + libName;
        }
        return String.valueOf(toolkit.getNatureId()) + "#" + libName;
    }

    private String getLibraryName(String key) {
        int pos = key.indexOf("#");
        if (pos != -1) {
            return key.substring(pos + 1);
        }
        return key;
    }

    private IDLTKLanguageToolkit getToolkitFromKey(String key) {
        int pos = key.indexOf("#");
        if (pos != -1) {
            String nature = key.substring(0, pos);
            return DLTKLanguageManager.getLanguageToolkit(nature);
        }
        return null;
    }

    public synchronized String[] getUserLibraryNames(IDLTKLanguageToolkit toolkit) {
        Set set = this.userLibraries.keySet();
        HashSet<String> result = new HashSet<String>();
        for (String key : set) {
            int pos = key.indexOf("#");
            if (pos == -1) continue;
            String nature = key.substring(0, pos);
            if (!toolkit.getNatureId().equals(nature)) continue;
            result.add(this.getLibraryName(key));
        }
        return result.toArray(new String[result.size()]);
    }

    private void initialize() {
        String[] propertyNames;
        this.userLibraries = new HashMap();
        IEclipsePreferences instancePreferences = ModelManager.getModelManager().getInstancePreferences();
        try {
            propertyNames = instancePreferences.keys();
        }
        catch (BackingStoreException e) {
            Util.log(e, "Exception while initializing user libraries");
            return;
        }
        boolean preferencesNeedFlush = false;
        int i = 0;
        int length = propertyNames.length;
        while (i < length) {
            block9: {
                String propertyValue;
                String propertyName = propertyNames[i];
                if (propertyName.startsWith(BP_USERLIBRARY_PREFERENCES_PREFIX) && (propertyValue = instancePreferences.get(propertyName, null)) != null) {
                    UserLibrary library;
                    String libName = propertyName.substring(BP_USERLIBRARY_PREFERENCES_PREFIX.length());
                    StringReader reader = new StringReader(propertyValue);
                    try {
                        library = UserLibrary.createFromString(reader);
                    }
                    catch (IOException e) {
                        Util.log(e, "Exception while initializing user library " + libName);
                        instancePreferences.remove(propertyName);
                        preferencesNeedFlush = true;
                        break block9;
                    }
                    this.userLibraries.put(libName, library);
                }
            }
            ++i;
        }
        if (preferencesNeedFlush) {
            try {
                instancePreferences.flush();
            }
            catch (BackingStoreException e) {
                Util.log(e, "Exception while flusing instance preferences");
            }
        }
    }

    public void updateUserLibrary(String libName, String encodedUserLibrary) {
        try {
            UserLibrary userLibrary;
            IPath containerPath = new Path("org.eclipse.dltk.USER_LIBRARY").append(this.getLibraryName(libName));
            IScriptProject[] allJavaProjects = DLTKCore.create(ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
            ArrayList<IScriptProject> affectedProjects = new ArrayList<IScriptProject>();
            int i = 0;
            while (i < allJavaProjects.length) {
                IScriptProject javaProject = allJavaProjects[i];
                IBuildpathEntry[] entries = javaProject.getRawBuildpath();
                int j = 0;
                while (j < entries.length) {
                    IBuildpathEntry entry = entries[j];
                    if (entry.getEntryKind() == 5 && containerPath.equals((Object)entry.getPath())) {
                        affectedProjects.add(javaProject);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            UserLibrary userLibrary2 = userLibrary = encodedUserLibrary == null ? null : UserLibrary.createFromString(new StringReader(encodedUserLibrary));
            if (userLibrary != null) {
                this.userLibraries.put(libName, userLibrary);
            } else {
                this.userLibraries.remove(libName);
            }
            int length = affectedProjects.size();
            if (length == 0) {
                return;
            }
            IScriptProject[] projects = new IScriptProject[length];
            affectedProjects.toArray(projects);
            IBuildpathContainer[] containers = new IBuildpathContainer[length];
            IDLTKLanguageToolkit toolkit = this.getToolkitFromKey(libName);
            if (userLibrary != null && toolkit != null) {
                UserLibraryBuildpathContainer container = new UserLibraryBuildpathContainer(this.getLibraryName(libName), toolkit);
                int i2 = 0;
                while (i2 < length) {
                    containers[i2] = container;
                    ++i2;
                }
            }
            DLTKCore.setBuildpathContainer(containerPath, projects, containers, null);
        }
        catch (IOException e) {
            Util.log(e, "Exception while decoding user library '" + libName + "'.");
        }
        catch (ModelException e) {
            Util.log((Throwable)((Object)e), "Exception while setting user library '" + libName + "'.");
        }
    }

    public synchronized void removeUserLibrary(String libName, IDLTKLanguageToolkit toolkit) {
        IEclipsePreferences instancePreferences = ModelManager.getModelManager().getInstancePreferences();
        String propertyName = BP_USERLIBRARY_PREFERENCES_PREFIX + UserLibraryManager.makeLibraryName(libName, toolkit);
        instancePreferences.remove(propertyName);
        try {
            instancePreferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e, "Exception while removing user library " + libName);
        }
    }

    public synchronized void setUserLibrary(String libName, IBuildpathEntry[] entries, boolean isSystemLibrary, IDLTKLanguageToolkit toolkit) {
        this.setUserLibrary(libName, entries, isSystemLibrary, null, toolkit);
    }

    public synchronized void setUserLibrary(String libName, IBuildpathEntry[] entries, boolean isSystemLibrary, Map<String, String> attributes, IDLTKLanguageToolkit toolkit) {
        IEclipsePreferences instancePreferences = ModelManager.getModelManager().getInstancePreferences();
        String propertyName = BP_USERLIBRARY_PREFERENCES_PREFIX + UserLibraryManager.makeLibraryName(libName, toolkit);
        try {
            String propertyValue = UserLibrary.serialize(entries, isSystemLibrary, attributes);
            instancePreferences.put(propertyName, propertyValue);
        }
        catch (IOException e) {
            Util.log(e, "Exception while serializing user library " + libName);
            return;
        }
        try {
            instancePreferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e, "Exception while saving user library " + libName);
        }
    }
}

