/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKContributionExtensionManager;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.internal.ui.preferences.ScriptSourcePreviewerUpdater;
import org.eclipse.dltk.internal.ui.text.DLTKColorManager;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.FormatterPreviewUtils;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IProfileManager;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.dltk.ui.formatter.internal.AbstractFormatterSelectionBlock;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractFormatterPreferencePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    @Override
    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener newStatusChangedListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new FormatterSelectionBlock(newStatusChangedListener, project, container);
    }

    protected abstract ScriptSourceViewerConfiguration createSimpleSourceViewerConfiguration(IColorManager var1, IPreferenceStore var2, ITextEditor var3, boolean var4);

    @Override
    protected abstract String getNatureId();

    protected abstract PreferenceKey getFormatterPreferenceKey();

    protected abstract IDialogSettings getDialogSettings();

    @Override
    protected String getHelpId() {
        return null;
    }

    @Override
    protected void setDescription() {
    }

    @Override
    protected String getPreferencePageId() {
        return null;
    }

    @Override
    protected String getProjectHelpId() {
        return null;
    }

    @Override
    protected String getPropertyPageId() {
        return null;
    }

    protected class FormatterSelectionBlock
    extends AbstractFormatterSelectionBlock {
        private IColorManager fColorManager;

        public FormatterSelectionBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
            super(context, project, AbstractFormatterPreferencePage.this.getFormatterPreferenceKey(), AbstractFormatterPreferencePage.this.getNatureId(), container);
            this.fColorManager = new DLTKColorManager(false);
        }

        @Override
        public void dispose() {
            this.fColorManager.dispose();
            super.dispose();
        }

        @Override
        protected DLTKContributionExtensionManager getExtensionManager() {
            return ScriptFormatterManager.getInstance();
        }

        @Override
        protected IFormatterModifyDialogOwner createDialogOwner() {
            return new FormatterModifyDialogOwner();
        }

        @Override
        public SourceViewer createPreview(Composite composite) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            ChainedPreferenceStore store = new ChainedPreferenceStore(new IPreferenceStore[]{AbstractFormatterPreferencePage.this.getPreferenceStore(), generalTextStore});
            ProjectionViewer fPreviewViewer = this.createPreviewViewer(composite, null, null, false, 2816, (IPreferenceStore)store);
            if (fPreviewViewer == null) {
                return null;
            }
            ScriptSourceViewerConfiguration configuration = AbstractFormatterPreferencePage.this.createSimpleSourceViewerConfiguration(this.fColorManager, (IPreferenceStore)store, null, false);
            fPreviewViewer.configure((SourceViewerConfiguration)configuration);
            if (fPreviewViewer.getTextWidget().getTabs() == 0) {
                fPreviewViewer.getTextWidget().setTabs(4);
            }
            new ScriptSourcePreviewerUpdater((SourceViewer)fPreviewViewer, configuration, (IPreferenceStore)store);
            fPreviewViewer.setEditable(false);
            Document document = new Document();
            IDLTKUILanguageToolkit toolkit = DLTKUILanguageManager.getLanguageToolkit(AbstractFormatterPreferencePage.this.getNatureId());
            toolkit.getTextTools().setupDocumentPartitioner((IDocument)document, toolkit.getPartitioningId());
            fPreviewViewer.setDocument((IDocument)document);
            return fPreviewViewer;
        }

        private ProjectionViewer createPreviewViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            return new ScriptSourceViewer(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
        }

        @Override
        protected String getPreferenceLinkMessage() {
            return FormatterMessages.FormatterPreferencePage_settingsLink;
        }

        @Override
        protected PreferenceKey getSavedContributionKey() {
            return AbstractFormatterPreferencePage.this.getFormatterPreferenceKey();
        }

        @Override
        protected void updatePreview() {
            if (this.fPreviewViewer != null) {
                IScriptFormatterFactory factory = this.getSelectedExtension();
                IProfileManager manager = this.getProfileManager(factory);
                FormatterPreviewUtils.updatePreview((ISourceViewer)this.fPreviewViewer, factory.getPreviewContent(), factory, manager.getSelected().getSettings());
            }
        }

        private class FormatterModifyDialogOwner
        implements IFormatterModifyDialogOwner {
            private FormatterModifyDialogOwner() {
            }

            @Override
            public ISourceViewer createPreview(Composite composite) {
                return FormatterSelectionBlock.this.createPreview(composite);
            }

            @Override
            public Shell getShell() {
                return AbstractFormatterPreferencePage.this.getShell();
            }

            @Override
            public IDialogSettings getDialogSettings() {
                return AbstractFormatterPreferencePage.this.getDialogSettings();
            }

            public IProfileManager getProfileManager() {
                return FormatterSelectionBlock.this.getProfileManager();
            }
        }
    }
}

