/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.core.dom.impl;

import org.eclipse.dltk.javascript.core.dom.BinaryExpression;
import org.eclipse.dltk.javascript.core.dom.BinaryOperator;
import org.eclipse.dltk.javascript.core.dom.DomPackage;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.impl.ExpressionImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class BinaryExpressionImpl
extends ExpressionImpl
implements BinaryExpression {
    protected Expression left;
    protected Expression right;
    protected static final BinaryOperator OPERATION_EDEFAULT = BinaryOperator.MUL;
    protected BinaryOperator operation = OPERATION_EDEFAULT;
    protected static final int OPERATOR_POSITION_EDEFAULT = 0;
    protected int operatorPosition = 0;

    protected BinaryExpressionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DomPackage.Literals.BINARY_EXPRESSION;
    }

    @Override
    public Expression getLeft() {
        return this.left;
    }

    public NotificationChain basicSetLeft(Expression newLeft, NotificationChain msgs) {
        Expression oldLeft = this.left;
        this.left = newLeft;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldLeft, (Object)newLeft);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLeft(Expression newLeft) {
        if (newLeft != this.left) {
            NotificationChain msgs = null;
            if (this.left != null) {
                msgs = ((InternalEObject)this.left).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newLeft != null) {
                msgs = ((InternalEObject)newLeft).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetLeft(newLeft, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newLeft, (Object)newLeft));
        }
    }

    @Override
    public Expression getRight() {
        return this.right;
    }

    public NotificationChain basicSetRight(Expression newRight, NotificationChain msgs) {
        Expression oldRight = this.right;
        this.right = newRight;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldRight, (Object)newRight);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setRight(Expression newRight) {
        if (newRight != this.right) {
            NotificationChain msgs = null;
            if (this.right != null) {
                msgs = ((InternalEObject)this.right).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newRight != null) {
                msgs = ((InternalEObject)newRight).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetRight(newRight, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newRight, (Object)newRight));
        }
    }

    @Override
    public BinaryOperator getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(BinaryOperator newOperation) {
        BinaryOperator oldOperation = this.operation;
        BinaryOperator binaryOperator = this.operation = newOperation == null ? OPERATION_EDEFAULT : newOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldOperation, (Object)this.operation));
        }
    }

    @Override
    public int getOperatorPosition() {
        return this.operatorPosition;
    }

    @Override
    public void setOperatorPosition(int newOperatorPosition) {
        int oldOperatorPosition = this.operatorPosition;
        this.operatorPosition = newOperatorPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldOperatorPosition, this.operatorPosition));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetLeft(null, msgs);
            }
            case 3: {
                return this.basicSetRight(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getLeft();
            }
            case 3: {
                return this.getRight();
            }
            case 4: {
                return this.getOperation();
            }
            case 5: {
                return this.getOperatorPosition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setLeft((Expression)newValue);
                return;
            }
            case 3: {
                this.setRight((Expression)newValue);
                return;
            }
            case 4: {
                this.setOperation((BinaryOperator)((Object)newValue));
                return;
            }
            case 5: {
                this.setOperatorPosition((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setLeft(null);
                return;
            }
            case 3: {
                this.setRight(null);
                return;
            }
            case 4: {
                this.setOperation(OPERATION_EDEFAULT);
                return;
            }
            case 5: {
                this.setOperatorPosition(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.left != null;
            }
            case 3: {
                return this.right != null;
            }
            case 4: {
                return this.operation != OPERATION_EDEFAULT;
            }
            case 5: {
                return this.operatorPosition != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (operation: ");
        result.append((Object)this.operation);
        result.append(", operatorPosition: ");
        result.append(this.operatorPosition);
        result.append(')');
        return result.toString();
    }
}

