/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.rhino.dbgp;

import org.eclipse.dltk.rhino.dbgp.DBGPDebugger;
import org.eclipse.dltk.rhino.dbgp.DBGPStackManager;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public final class DBGPDebugFrame
implements DebugFrame {
    private final String sourceName;
    private final DBGPStackManager stackManager;
    private int lineNumber;
    private String where;
    private Scriptable thisObj;
    private Scriptable scope;
    private DebuggableScript script;
    private Object[] args;
    private Context context;
    private boolean suspend;
    private boolean callOnEnter;

    public boolean isSuspend() {
        return this.suspend;
    }

    public void setSuspend(boolean suspend) {
        this.suspend = suspend;
    }

    public DBGPDebugFrame(Context ct, DebuggableScript node, DBGPDebugger debugger) {
        this.sourceName = node.getSourceName();
        this.context = ct;
        this.stackManager = DBGPStackManager.getManager(ct);
        this.where = node.getFunctionName();
        this.script = node;
        if (this.where == null) {
            this.where = "module";
        }
    }

    public String[] getParametersAndVars() {
        String[] result = new String[this.script.getParamAndVarCount()];
        int a = 0;
        while (a < result.length) {
            result[a] = this.script.getParamOrVarName(a);
            ++a;
        }
        return result;
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.args = args;
        this.scope = activation;
        this.thisObj = thisObj;
        this.callOnEnter = true;
    }

    public void onExceptionThrown(Context cx, Throwable ex) {
        this.stackManager.exceptionThrown(ex);
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        this.stackManager.exit(this);
    }

    public void onLineChange(Context cx, int lineNumber) {
        this.lineNumber = lineNumber;
        if (this.callOnEnter) {
            this.callOnEnter = false;
            this.stackManager.enter(this);
        } else {
            this.stackManager.changeLine(this, lineNumber);
        }
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getWhere() {
        return this.where;
    }

    public Object getValue(int num) {
        Object object = this.scope.get(this.script.getParamOrVarName(num), this.thisObj);
        return object;
    }

    public Object getStackFrameArgs() {
        Object object = this.scope.get("arguments", this.thisObj);
        return object;
    }

    public Scriptable getThis() {
        return this.thisObj;
    }

    public void setValue(String name, String value) {
        if (name.startsWith("this.")) {
            name = name.substring("this.".length());
            this.thisObj.put(name, this.thisObj, this.eval(value));
        } else {
            this.scope.put(name, this.scope, (Object)value);
        }
    }

    public Object eval(String value) {
        Debugger debugger = this.context.getDebugger();
        try {
            Object evaluateString;
            this.context.setDebugger(null, null);
            Scriptable cs = this.scope;
            if (value.startsWith("this.")) {
                value = value.substring("this.".length());
                cs = this.thisObj;
            }
            Object object = evaluateString = this.context.evaluateString(cs, value, "eval", 0, null);
            return object;
        }
        catch (Throwable e) {
            String string = "Error during evaluation:" + e.getMessage();
            return string;
        }
        finally {
            this.context.setDebugger(debugger, null);
        }
    }

    public Object getValue(String longName) {
        if (longName.startsWith("this")) {
            int indexOf = longName.indexOf(46);
            if (indexOf == -1) {
                return this.thisObj;
            }
            longName = longName.substring("this.".length());
            return this.getProperty(this.thisObj, longName);
        }
        return this.getProperty(this.scope, longName);
    }

    private Object getProperty(Scriptable obj, String longName) {
        int k = longName.indexOf(46);
        if (k == -1) {
            return this.shortGet(obj, longName);
        }
        String shortName = longName.substring(0, k);
        String sm = longName.substring(k + 1);
        Object property = this.shortGet(obj, shortName);
        if (property instanceof Scriptable) {
            return this.getProperty((Scriptable)property, sm);
        }
        return null;
    }

    private Object shortGet(Scriptable obj, String longName) {
        if (obj instanceof NativeJavaArray || obj instanceof NativeArray) {
            if ((longName = longName.trim()).startsWith("[")) {
                longName = longName.substring(1, longName.length() - 1);
            }
            int parseInt = Integer.parseInt(longName);
            return obj.get(parseInt, obj);
        }
        Scriptable parent = obj;
        while (parent != null) {
            Object o = ScriptableObject.getProperty((Scriptable)parent, (String)longName);
            if (o != null && o != Scriptable.NOT_FOUND) {
                return o;
            }
            parent = parent.getParentScope();
        }
        try {
            int parseInt = Integer.parseInt(longName);
            Object o = ScriptableObject.getProperty((Scriptable)obj, (int)parseInt);
            if (o != null && o != Scriptable.NOT_FOUND) {
                return o;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

