/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.ti.ElementValue;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.ImmutableValue;
import org.eclipse.dltk.internal.javascript.ti.PositionReachedException;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitor;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitorBase;
import org.eclipse.dltk.internal.javascript.ti.TypeSystemImpl;
import org.eclipse.dltk.internal.javascript.ti.ValueWithElementValue;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;
import org.eclipse.dltk.javascript.internal.core.ThreadTypeSystemImpl;
import org.eclipse.dltk.javascript.parser.JSProblem;
import org.eclipse.dltk.javascript.parser.JSProblemReporter;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinfo.AttributeKey;
import org.eclipse.dltk.javascript.typeinfo.IElementResolver;
import org.eclipse.dltk.javascript.typeinfo.ILocalTypeReference;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRTypeTransformer;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeProvider;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.Property;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class TypeInferencer2
extends TypeSystemImpl
implements ITypeInferenceContext {
    private TypeInferencerVisitor visitor;
    private ReferenceSource source;
    private static final boolean DEBUG = false;
    private final Map<String, LocalTypeBucket> localTypes = new HashMap<String, LocalTypeBucket>();
    private final Map<String, Type> types = new HashMap<String, Type>();
    private final Map<String, Boolean> activeTypeRequests = new HashMap<String, Boolean>();
    private ITypeProvider[] typeProviders = null;
    private final TypeResourceSet typeRS = new TypeResourceSet();
    private boolean resolve = true;
    private Map<String, IRMember> elements = new HashMap<String, IRMember>();
    private IModelBuilder[] modelBuilders = null;
    private final Map<AttributeKey<?>, List<Object>> attributes = new HashMap();
    private Map<String, Object> recordTypes = new HashMap<String, Object>();

    private void initializeVisitor() {
        if (this.visitor == null) {
            this.visitor = new TypeInferencerVisitor(this);
        }
        this.visitor.initialize();
    }

    public void setVisitor(TypeInferencerVisitor visitor) {
        this.visitor = visitor;
    }

    public void setModelElement(IModelElement modelElement) {
        this.setSource(ReferenceSource.create(modelElement));
    }

    public void setSource(ReferenceSource source) {
        this.source = source;
    }

    /*
     * Loose catch block
     */
    public void doInferencing(Script script) {
        ITypeSystem saved = CURRENT.get();
        try {
            try {
                ((ThreadTypeSystemImpl)CURRENT).set(this);
                this.elements.clear();
                this.modelBuilders = null;
                this.typeProviders = null;
                this.initializeVisitor();
                this.visitor.visit((ASTNode)script);
                this.visitor.done();
            }
            catch (PositionReachedException e) {
                throw e;
            }
            catch (TypeInferencerVisitorBase.TIWrappedException e) {
                this.log(e.getCause());
                ((ThreadTypeSystemImpl)CURRENT).set(saved);
            }
            catch (RuntimeException e) {
                this.log(e);
                ((ThreadTypeSystemImpl)CURRENT).set(saved);
            }
            catch (AssertionError e) {
                this.log((Throwable)((Object)e));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ((ThreadTypeSystemImpl)CURRENT).set(saved);
            }
        }
        finally {
            ((ThreadTypeSystemImpl)CURRENT).set(saved);
        }
    }

    protected void log(Throwable e) {
        JSProblemReporter reporter = this.visitor.getProblemReporter();
        if (reporter != null) {
            reporter.reportProblem((IProblem)new JSProblem(e));
        }
        JavaScriptPlugin.error(e);
    }

    public IValueReference evaluate(ASTNode node) {
        this.initializeVisitor();
        return this.visitor.visit(node);
    }

    public IValueCollection getCollection() {
        return this.visitor.getCollection();
    }

    @Override
    public IValueCollection currentCollection() {
        return this.visitor.peekContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalTypeReference registerLocalType(Type type) {
        LocalType result;
        assert (type != null);
        String name = type.getName();
        assert (name != null);
        assert (type.eResource() == null);
        Map<String, LocalTypeBucket> map = this.localTypes;
        synchronized (map) {
            LocalTypeBucket locals = this.localTypes.get(name);
            if (locals == null) {
                locals = new LocalTypeBucket();
                this.localTypes.put(name, locals);
            } else {
                for (LocalType localType : locals) {
                    if (!type.equals(localType.type)) continue;
                    return localType;
                }
            }
            result = new LocalType(type);
            this.typeRS.addToResource(type);
            locals.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILocalTypeReference[] getLocalTypes(String name) {
        Map<String, LocalTypeBucket> map = this.localTypes;
        synchronized (map) {
            LocalTypeBucket locals = this.localTypes.get(name);
            if (locals != null) {
                return locals.toArray(new ILocalTypeReference[locals.size()]);
            }
            return new ILocalTypeReference[0];
        }
    }

    @Override
    public Type getType(String typeName) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, null, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), true);
    }

    @Override
    public SimpleType getTypeRef(String typeName) {
        return TypeUtil.ref(this.getType(typeName));
    }

    @Override
    public Type getKnownType(String typeName) {
        return this.getKnownType(typeName, null);
    }

    @Override
    public Type getKnownType(String typeName, TypeMode mode) {
        boolean queryProviders;
        if (typeName == null || typeName.length() == 0) {
            return null;
        }
        return this.getType(typeName, mode, queryProviders, true, !(queryProviders = this.canQueryTypeProviders()), false);
    }

    protected boolean resolveToUnknown() {
        return true;
    }

    @Override
    public Type doResolveType(Type type) {
        String typeName = URI.decode((String)((InternalEObject)type).eProxyURI().fragment());
        Type resolved = this.getType(typeName, null, true, true, false, this.resolveToUnknown());
        if (resolved != null) {
            return resolved;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listTypes(TypeMode mode, String prefix) {
        Set<String> typeNames;
        HashSet<String> result = new HashSet<String>();
        TypeInfoModelLoader loader = TypeInfoModelLoader.getInstance();
        Set<String> set = typeNames = mode == TypeMode.CODE ? loader.listTypeLiterals(prefix) : loader.listTypes(prefix);
        if (typeNames != null) {
            result.addAll(typeNames);
        }
        ITypeProvider[] iTypeProviderArray = this.getTypeProviders();
        int n = iTypeProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeProvider provider = iTypeProviderArray[n2];
            typeNames = provider.listTypes(this, mode, prefix);
            if (typeNames != null) {
                result.addAll(typeNames);
            }
            ++n2;
        }
        String lowerPrefix = prefix.toLowerCase();
        Map<String, LocalTypeBucket> map = this.localTypes;
        synchronized (map) {
            Set<String> localTypeNames = this.localTypes.keySet();
            for (String name : localTypeNames) {
                String typeName = name;
                if (typeName.toLowerCase().equals(lowerPrefix)) continue;
                int index = typeName.lastIndexOf(46);
                if (index != -1) {
                    typeName = typeName.substring(index + 1);
                }
                if (!typeName.toLowerCase().startsWith(lowerPrefix)) continue;
                result.add(name);
            }
        }
        return result;
    }

    @Override
    public ReferenceSource getSource() {
        return this.source;
    }

    @Override
    public IValueCollection getTopValueCollection() {
        if (this.resolve) {
            IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
            int n = iMemberEvaluatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                IValueCollection collection = evaluator.getTopValueCollection(this);
                if (collection != null) {
                    return collection;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IModelElement getModelElement() {
        return this.source != null ? this.source.getModelElement() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type getType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined, boolean allowProxy, boolean allowUnknown) {
        Type type;
        Map<String, LocalTypeBucket> map = this.localTypes;
        synchronized (map) {
            LocalTypeBucket locals = this.localTypes.get(typeName);
            if (locals != null) {
                for (LocalType localType : locals) {
                    if (!localType.isEnabled()) continue;
                    return localType.type;
                }
                if (locals.unknownType != null) {
                    return allowUnknown ? locals.unknownType : null;
                }
            }
        }
        Map<String, Type> map2 = this.types;
        synchronized (map2) {
            type = this.types.get(typeName);
        }
        if (type != null) {
            return type;
        }
        type = this.loadType(typeName, mode, queryProviders, queryPredefined);
        if (type != null) {
            this.validateTypeInfo(type);
            map2 = this.types;
            synchronized (map2) {
                this.types.put(typeName, type);
            }
            this.typeRS.addToResource(type);
            return type;
        }
        if (allowProxy) {
            return TypeUtil.createProxy(typeName);
        }
        if (allowUnknown) {
            return this.createUnknown(typeName);
        }
        return null;
    }

    private void validateTypeInfo(Type type) {
        ResourceSet resourceSet;
        Resource resource = type.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            Assert.isLegal((!(resourceSet instanceof TypeResourceSet) ? 1 : 0) != 0, (String)("Type " + type.getName() + " has invalid resource: " + resource + " (" + resourceSet.getClass() + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type createUnknown(String typeName) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(typeName);
        type.setKind(TypeKind.UNKNOWN);
        Map<String, LocalTypeBucket> map = this.localTypes;
        synchronized (map) {
            LocalTypeBucket locals = this.localTypes.get(typeName);
            if (locals != null) {
                for (LocalType localType : locals) {
                    if (!localType.isEnabled()) continue;
                    return localType.type;
                }
                if (locals.unknownType != null) {
                    return locals.unknownType;
                }
            } else {
                locals = new LocalTypeBucket();
                this.localTypes.put(typeName, locals);
            }
            locals.unknownType = type;
        }
        this.typeRS.add(type);
        return type;
    }

    private boolean canQueryTypeProviders() {
        return this.activeTypeRequests.isEmpty();
    }

    private Type loadType(String typeName, TypeMode mode, boolean queryProviders, boolean queryPredefined) {
        if (queryProviders && this.activeTypeRequests.put(typeName, Boolean.FALSE) == null) {
            try {
                ITypeProvider[] iTypeProviderArray = this.getTypeProviders();
                int n = iTypeProviderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeProvider provider = iTypeProviderArray[n2];
                    Type type = provider.getType(this, mode, typeName);
                    if (type != null && !type.eIsProxy()) {
                        Type type2 = type;
                        return type2;
                    }
                    ++n2;
                }
            }
            finally {
                this.activeTypeRequests.remove(typeName);
            }
        }
        if (queryPredefined) {
            TypeInfoModelLoader loader = TypeInfoModelLoader.getInstance();
            Type type = mode == TypeMode.CODE ? loader.getTypeLiteral(typeName) : loader.getType(typeName);
            if (type != null) {
                return type;
            }
        }
        return null;
    }

    @Override
    public ITypeProvider[] getTypeProviders() {
        if (this.typeProviders == null) {
            this.typeProviders = this.createTypeProviders();
        }
        return this.typeProviders;
    }

    protected ITypeProvider[] createTypeProviders() {
        return TypeInfoManager.createTypeProviders(this);
    }

    @Override
    public IRMember resolve(String name) {
        if (name == null) {
            return null;
        }
        Object element = this.elements.get(name);
        if (element != null) {
            return element;
        }
        element = TypeInfoModelLoader.getInstance().getMember(name);
        if (element != null) {
            IRMember r = this.convertMember((Member)element, null);
            this.elements.put(name, r);
            return r;
        }
        if (this.resolve) {
            IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
            int n = iElementResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElementResolver resolver = iElementResolverArray[n2];
                element = resolver.resolveElement(this, name);
                if (element != null) {
                    IRMember r = this.convertMember((Member)element, null);
                    this.elements.put(name, r);
                    return r;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IValue valueOf(IRMember member) {
        if (!(member.getSource() instanceof Member)) {
            return null;
        }
        Member source = (Member)member.getSource();
        IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
        int n = iMemberEvaluatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
            IValueCollection collection = evaluator.valueOf(this, source);
            if (collection != null) {
                if (!(collection instanceof IValueProvider)) break;
                IValue value = ((IValueProvider)((Object)collection)).getValue();
                if (member.getType() != null) {
                    value.setDeclaredType(member.getType());
                }
                if (value.getKind() == ReferenceKind.UNKNOWN) {
                    if (source instanceof Property) {
                        value.setKind(ReferenceKind.PROPERTY);
                    } else {
                        value.setKind(ReferenceKind.METHOD);
                    }
                }
                if (value instanceof ImmutableValue) {
                    ElementValue elementValue = ElementValue.createFor(member);
                    return new ValueWithElementValue((ImmutableValue)value, elementValue);
                }
                return value;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<String> listGlobals(String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (Member member : TypeInfoModelLoader.getInstance().listMembers(prefix)) {
            result.add(member.getName());
        }
        IElementResolver[] iElementResolverArray = TypeInfoManager.getElementResolvers();
        int n = iElementResolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElementResolver resolver = iElementResolverArray[n2];
            Set<String> globals = resolver.listGlobals(this, prefix);
            if (globals != null) {
                result.addAll(globals);
            }
            ++n2;
        }
        return result;
    }

    public void setDoResolve(boolean resolve) {
        this.resolve = resolve;
    }

    @Override
    public IModelBuilder[] getModelBuilders() {
        if (this.modelBuilders == null) {
            this.modelBuilders = TypeInfoManager.getModelBuilders(this);
        }
        return this.modelBuilders;
    }

    @Override
    public <T> T getAttribute(AttributeKey<T> key) {
        List<Object> values = this.attributes.get(key);
        return (T)(values != null && !values.isEmpty() ? values.get(values.size() - 1) : null);
    }

    @Override
    public <T> void pushAttribute(AttributeKey<T> key, T value) {
        List<Object> values = this.attributes.get(key);
        if (values == null) {
            values = new ArrayList<Object>(4);
            this.attributes.put(key, values);
        }
        values.add(value);
    }

    @Override
    public <T> T popAttribute(AttributeKey<T> key) {
        List<Object> values = this.attributes.get(key);
        if (values != null && !values.isEmpty()) {
            return (T)values.remove(values.size() - 1);
        }
        return null;
    }

    public String toString() {
        TypeInferencerVisitor v = this.visitor;
        String className = this.getClass().getSimpleName();
        if (className.length() == 0) {
            className = this.getClass().getName();
        }
        return String.valueOf(className) + "(" + this.source + "," + (v != null ? v.getClass().getSimpleName() : null) + ")";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ITypeInfoContext.class || adapter == ITypeSystem.class) {
            return this;
        }
        if (adapter == ReferenceSource.class) {
            return this.getSource();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLocalState() {
        ArrayList<Type> copy;
        Map<String, LocalTypeBucket> map = this.localTypes;
        synchronized (map) {
            copy = new ArrayList<Type>();
            for (LocalTypeBucket locals : this.localTypes.values()) {
                for (LocalType localType : locals) {
                    copy.add(localType.type);
                }
                if (locals.unknownType == null) continue;
                copy.add(locals.unknownType);
            }
            this.localTypes.clear();
        }
        if (!copy.isEmpty()) {
            this.typeRS.removeAll(copy);
        }
        this.attributes.clear();
    }

    @Override
    public IRType contextualize(JSType type) {
        if (type != null) {
            IRType rt = RTypes.create(this, type);
            IRTypeDeclaration contextTypeDeclaration = (IRTypeDeclaration)this.getAttribute(CONTEXTUALIZE_WITH);
            if (contextTypeDeclaration != null && TypeInferencer2.isContextualizable(rt)) {
                IRTypeTransformer transformer = this.newTypeContextualizer(contextTypeDeclaration);
                return transformer.transform(rt);
            }
            return rt;
        }
        return null;
    }

    @Override
    public void registerRecordType(RecordType type) {
        this.recordTypes.put(type.getName(), type);
    }

    @Override
    public IRRecordType resolveRecordType(String name) {
        Object recordType = this.recordTypes.get(name);
        if (recordType instanceof IRRecordType) {
            return (IRRecordType)recordType;
        }
        if (recordType instanceof RecordType) {
            IRRecordType irType = RTypes.recordType();
            this.recordTypes.put(name, irType);
            irType.init(this, ((RecordType)recordType).getMembers());
            return irType;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public IRLocalType resolveLocalType(String name) {
        block5: {
            if (this.visitor == null) {
                return null;
            }
            result = null;
            currentCollection = this.currentCollection();
            if (name.indexOf(46) == -1) ** GOTO lbl23
            scopes = name.split("\\.");
            child /* !! */  = currentCollection;
            var9_7 = scopes;
            var8_8 = scopes.length;
            var7_9 = 0;
            while (var7_9 < var8_8) {
                scope = var9_7[var7_9];
                child /* !! */  = child /* !! */ .getChild(scope);
                ++var7_9;
            }
            result = (IValueReference)child /* !! */ ;
            break block5;
lbl-1000:
            // 1 sources

            {
                child = currentCollection.getChild(name);
                if (child.exists()) {
                    result = child;
                    break;
                }
                currentCollection = currentCollection.getParent();
lbl23:
                // 2 sources

                ** while (currentCollection != null)
            }
        }
        if (result != null && result.getKind() == ReferenceKind.FUNCTION) {
            return RTypes.localType(name, result);
        }
        return null;
    }

    private static class LocalType
    implements ILocalTypeReference {
        final Type type;
        private boolean enabled;

        public LocalType(Type type) {
            this.type = type;
            this.enabled = true;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean value) {
            this.enabled = value;
        }

        public String toString() {
            return "(" + this.type + ", enabled=" + this.enabled + ")";
        }
    }

    private static class LocalTypeBucket
    extends ArrayList<LocalType> {
        Type unknownType;

        public LocalTypeBucket() {
            super(1);
        }
    }

    private static enum TypeResolveMode {
        SIMPLE,
        PROXY,
        UNKNOWN;

    }

    private class TypeResourceSet
    extends ResourceSetImpl {
        private Resource typesResource = null;

        public TypeResourceSet() {
            TypeInfoModelLoader.getInstance().initializeURIMap((ResourceSet)this);
        }

        public EObject getEObject(URI uri, boolean loadOnDemand) {
            if (TypeUtil.isTypeProxy(uri)) {
                String typeName = URI.decode((String)uri.fragment());
                Type type = this.resolveTypeProxy(typeName);
                if (type == null) {
                    return TypeInferencer2.this.createUnknown(typeName);
                }
                return type;
            }
            return super.getEObject(uri, loadOnDemand);
        }

        protected Type resolveTypeProxy(String typeName) {
            return TypeInferencer2.this.getType(typeName, null, true, false, false, false);
        }

        public synchronized Resource getResource() {
            if (this.typesResource == null) {
                this.typesResource = new ResourceImpl(TypeUtil.createProxyResourceURI());
                this.getResources().add((Object)this.typesResource);
            }
            return this.typesResource;
        }

        public void addToResource(Type type) {
            Type object = type;
            if (object.eResource() == null) {
                this.add(type);
            }
        }

        protected synchronized void add(Type type) {
            this.getResource().getContents().add((Object)type);
        }

        protected synchronized void removeAll(Collection<Type> types) {
            this.getResource().getContents().removeAll(types);
        }
    }
}

