/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.javascript.core.Types;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRTypeTransformer;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.RType;
import org.eclipse.dltk.javascript.typeinfo.TypeCompatibility;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

public class RSimpleType
extends RType
implements IRSimpleType {
    @NonNull
    private final IRTypeDeclaration declaration;

    protected RSimpleType(ITypeSystem typeSystem, Type target) {
        assert (target != null);
        this.declaration = typeSystem.convert(target);
    }

    protected RSimpleType(IRTypeDeclaration declaration) {
        assert (declaration != null);
        this.declaration = declaration;
    }

    @Override
    public String getName() {
        return this.declaration.getName();
    }

    @Override
    public Type getTarget() {
        return this.declaration.getSource();
    }

    @Override
    public IRTypeDeclaration getDeclaration() {
        return this.declaration;
    }

    public int hashCode() {
        return this.declaration.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RSimpleType other = (RSimpleType)obj;
        return this.declaration.equals(other.declaration);
    }

    @Override
    public TypeCompatibility isAssignableFrom(IRType type) {
        if (super.isAssignableFrom(type).ok()) {
            return TypeCompatibility.TRUE;
        }
        if (Types.OBJECT == this.declaration.getSource()) {
            return TypeCompatibility.valueOf(type.isJavaScriptObject());
        }
        if (Types.FUNCTION == this.declaration.getSource() && type instanceof IRFunctionType) {
            return TypeCompatibility.TRUE;
        }
        if (type instanceof RSimpleType) {
            IRTypeDeclaration other = ((RSimpleType)type).getDeclaration();
            return this.declaration.isAssignableFrom(other);
        }
        if (type instanceof IRLocalType && this.getTarget().getKind() == TypeKind.UNKNOWN && type.getName().equals(this.getName())) {
            return TypeCompatibility.TRUE;
        }
        return this.testAssignableTo(type);
    }

    @Override
    public boolean isJavaScriptObject() {
        TypeKind kind = this.declaration.getSource().getKind();
        return kind == TypeKind.PREDEFINED || kind == TypeKind.JAVASCRIPT;
    }

    @Override
    public IRType transform(IRTypeTransformer function) {
        IRTypeDeclaration value = function.transform(this.declaration);
        if (value != this.declaration) {
            return new RSimpleType(value);
        }
        return this;
    }
}

