/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ruby.ast.IRubyASTVisitor;
import org.eclipse.dltk.ruby.ast.RubyModuleDeclaration;

public class RubyClassDeclaration
extends RubyModuleDeclaration {
    private static final String OBJECT = "Object";
    private static final List<String> OBJECT_SUPER_CLASS = Collections.singletonList("Object");

    public RubyClassDeclaration(ASTNode superClass, ASTNode name, Block body, int start, int end) {
        super(name, body, start, end);
        this.setNameStart(name.sourceStart());
        this.setNameEnd(name.sourceEnd());
        this.addSuperClass(superClass);
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((TypeDeclaration)this)) {
            ASTNode className;
            if (this.getSuperClasses() != null) {
                this.getSuperClasses().traverse(visitor);
            }
            if ((className = this.getClassName()) != null) {
                if (visitor instanceof IRubyASTVisitor) {
                    ((IRubyASTVisitor)visitor).visitTypeName(className);
                } else {
                    className.traverse(visitor);
                }
            }
            if (this.getBody() != null) {
                this.getBody().traverse(visitor);
            }
            visitor.endvisit((TypeDeclaration)this);
        }
    }

    public List<String> getSuperClassNames() {
        List<String> names = super.getSuperClassNames();
        if ((names == null || names.isEmpty()) && !OBJECT.equals(this.getName())) {
            names = OBJECT_SUPER_CLASS;
        }
        return names;
    }
}

