/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.List;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.IRElement;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRParameter;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterKind;

public class RUtils {
    public static ReferenceLocation locationOf(IRElement element) {
        Object source = element.getSource();
        if (source instanceof IModelBuilder.IElement) {
            return ((IModelBuilder.IElement)source).getLocation();
        }
        return null;
    }

    @Nullable
    public static IRParameter getParameterFor(IRMethod method, int position) {
        IRParameter last;
        if (position < 0) {
            return null;
        }
        List<IRParameter> params = method.getParameters();
        if (position < params.size()) {
            return params.get(position);
        }
        if (!params.isEmpty() && (last = params.get(params.size() - 1)).getKind() == ParameterKind.VARARGS) {
            return last;
        }
        return null;
    }
}

