/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.console;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugConsole;
import org.eclipse.dltk.internal.debug.ui.console.ConsoleRemoveAllTerminatedAction;
import org.eclipse.dltk.internal.debug.ui.console.ConsoleRemoveLaunchAction;
import org.eclipse.dltk.internal.debug.ui.console.ConsoleTerminateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class ScriptDebugConsolePageParticipant
implements IConsolePageParticipant,
IShowInSource,
IShowInTargetList,
IDebugEventSetListener,
IDebugContextListener {
    private ConsoleTerminateAction fTerminate;
    private ConsoleRemoveLaunchAction fRemoveTerminated;
    private ConsoleRemoveAllTerminatedAction fRemoveAllTerminated;
    private ScriptDebugConsole fConsole;
    private IPageBookViewPage fPage;
    private IConsoleView fView;
    private EOFHandler fEOFHandler;
    private String fContextId = "org.eclipse.debug.ui.console";
    private IContextActivation fActivatedContext;
    private IHandlerActivation fActivatedHandler;

    public void init(IPageBookViewPage page, IConsole console) {
        this.fPage = page;
        this.fConsole = (ScriptDebugConsole)console;
        this.fRemoveTerminated = new ConsoleRemoveLaunchAction(this.fConsole.getLaunch());
        this.fRemoveAllTerminated = new ConsoleRemoveAllTerminatedAction();
        this.fTerminate = new ConsoleTerminateAction(page.getSite().getWorkbenchWindow(), this.fConsole);
        this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        IActionBars actionBars = this.fPage.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
        this.fEOFHandler = new EOFHandler();
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.fRemoveTerminated != null) {
            this.fRemoveTerminated.dispose();
            this.fRemoveTerminated = null;
        }
        if (this.fRemoveAllTerminated != null) {
            this.fRemoveAllTerminated.dispose();
            this.fRemoveAllTerminated = null;
        }
        if (this.fTerminate != null) {
            this.fTerminate.dispose();
            this.fTerminate = null;
        }
        this.fConsole = null;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", (IAction)this.fTerminate);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveTerminated);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveAllTerminated);
    }

    public <T> T getAdapter(Class<T> required) {
        if (IShowInSource.class.equals(required)) {
            return (T)this;
        }
        if (IShowInTargetList.class.equals(required)) {
            return (T)this;
        }
        if (ILaunchConfiguration.class.equals(required)) {
            ILaunch launch = this.fConsole.getLaunch();
            if (launch != null) {
                return (T)launch.getLaunchConfiguration();
            }
            return null;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter(IDebugTarget.class);
        TreeSelection selection = null;
        selection = target == null ? new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), process.getLaunch(), process})) : new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), target.getLaunch(), target}));
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (ScriptDebugConsolePageParticipant.this.fTerminate != null) {
                            ScriptDebugConsolePageParticipant.this.fTerminate.update();
                        }
                    }
                };
                DLTKDebugUIPlugin.getStandardDisplay().asyncExec(r);
            }
            ++i;
        }
    }

    protected IProcess getProcess() {
        return this.fConsole != null ? this.fConsole.getProcess() : null;
    }

    public void activated() {
        IPageSite site = this.fPage.getSite();
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        this.fActivatedContext = contextService.activateContext(this.fContextId);
        this.fActivatedHandler = handlerService.activateHandler("org.eclipse.debug.ui.commands.eof", (IHandler)this.fEOFHandler);
    }

    public void deactivated() {
        IPageSite site = this.fPage.getSite();
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        handlerService.deactivateHandler(this.fActivatedHandler);
        contextService.deactivateContext(this.fActivatedContext);
    }

    public void debugContextChanged(DebugContextEvent event) {
        IProcess process;
        if ((event.getFlags() & 1) > 0 && (process = this.getProcess()) != null && this.fView != null && process.equals(DebugUITools.getCurrentProcess())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }

    private class EOFHandler
    extends AbstractHandler {
        private EOFHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IStreamsProxy proxy = ScriptDebugConsolePageParticipant.this.getProcess().getStreamsProxy();
            if (proxy instanceof IStreamsProxy2) {
                IStreamsProxy2 proxy2 = (IStreamsProxy2)proxy;
                try {
                    proxy2.closeInputStream();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

