/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.core.ISourceNode;
import org.eclipse.dltk.javascript.ast.Argument;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.structure.ArgumentNode;
import org.eclipse.dltk.javascript.structure.IParentNode;
import org.eclipse.dltk.javascript.structure.IStructureContext;
import org.eclipse.dltk.javascript.structure.IStructureNode;
import org.eclipse.dltk.javascript.structure.IStructureRequestor;
import org.eclipse.dltk.javascript.structure.Scope;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;

public abstract class FunctionNode
extends Scope {
    final FunctionStatement function;
    final IModelBuilder.IMethod method;
    private String returnType;

    public FunctionNode(IParentNode parent, FunctionStatement function, IModelBuilder.IMethod method) {
        super(parent);
        this.function = function;
        this.method = method;
    }

    public void buildArgumentNodes() {
        for (Argument argument : this.function.getArguments()) {
            String name;
            IModelBuilder.IParameter parameter = this.method.getParameter(name = argument.getArgumentName());
            this.addChild(new ArgumentNode(this, name, parameter != null ? parameter.getType() : null, ReferenceLocation.create(this.method.getLocation().getSource(), argument.start(), argument.end())));
        }
    }

    public JSType getType() {
        return this.method.getType();
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public int start() {
        return this.getNameNode().start();
    }

    protected String argumentsToString() {
        StringBuilder sb = new StringBuilder();
        for (ArgumentNode argument : this.getArguments()) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(argument.getName());
            if (argument.getType() == null) continue;
            sb.append(':');
            sb.append(argument.getType().getName());
        }
        return sb.toString();
    }

    protected List<ArgumentNode> getArguments() {
        List<ArgumentNode> result = null;
        for (IStructureNode iStructureNode : this.getChildren()) {
            if (!(iStructureNode instanceof ArgumentNode)) continue;
            if (result == null) {
                result = new ArrayList<ArgumentNode>(this.function.getArguments().size());
            }
            result.add((ArgumentNode)iStructureNode);
        }
        return result != null ? result : Collections.emptyList();
    }

    @Override
    public void reportStructure(IStructureRequestor requestor, IStructureContext context) {
        boolean allowed = context.allow(2);
        if (allowed) {
            IElementRequestor.MethodInfo info = new IElementRequestor.MethodInfo();
            ISourceNode nameNode = this.getNameNode();
            info.declarationStart = Math.min(nameNode.start(), this.function.start());
            info.name = this.getName();
            if (this.method.getVisibility() != null) {
                info.modifiers |= this.method.getVisibility().getFlags();
            }
            if (this.method.isDeprecated()) {
                info.modifiers |= 0x40000;
            }
            info.nameSourceStart = nameNode.start();
            info.nameSourceEnd = nameNode.end() - 1;
            List<ArgumentNode> arguments = this.getArguments();
            if (!arguments.isEmpty()) {
                int argumentCount = arguments.size();
                info.parameterNames = new String[argumentCount];
                info.parameterTypes = new String[argumentCount];
                int i = 0;
                while (i < argumentCount) {
                    ArgumentNode argument = arguments.get(i);
                    info.parameterNames[i] = argument.getName();
                    info.parameterTypes[i] = this.typeToModel(argument.getType());
                    ++i;
                }
            }
            info.returnType = this.typeToModel(this.getType());
            if (info.returnType == null) {
                info.returnType = this.returnType;
            }
            info.isConstructor = this.method.isConstructor();
            requestor.enterMethod(info, this.getStructureNameNode(), this.function, this.method);
        }
        context.pushMask(1);
        super.reportStructure(requestor, context);
        context.popMask();
        if (allowed) {
            requestor.exitMethod(this.function.end() - 1);
        }
    }

    protected Expression getStructureNameNode() {
        return this.function.getName();
    }

    protected abstract String getName();

    public abstract ISourceNode getNameNode();
}

