/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.ScriptElementLabels;

public class PatternStrings {
    public static String getMethodSignature(IMethod method) {
        StringBuilder buffer = new StringBuilder();
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)method);
        if (toolkit != null) {
            ISearchPatternProcessor patternProcessor = DLTKLanguageManager.getSearchPatternProcessor((IDLTKLanguageToolkit)toolkit);
            IType type = method.getDeclaringType();
            if (type != null) {
                if (patternProcessor != null) {
                    buffer.append(type.getTypeQualifiedName(patternProcessor.getDelimiterReplacementString()));
                } else {
                    buffer.append(type.getTypeQualifiedName());
                }
                if (patternProcessor != null) {
                    buffer.append(patternProcessor.getDelimiterReplacementString());
                } else {
                    buffer.append('.');
                }
            }
        }
        buffer.append(method.getElementName());
        buffer.append("(");
        if (method.exists()) {
            try {
                int count = 0;
                String[] stringArray = method.getParameterNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray[n2];
                    if (count != 0) {
                        buffer.append(",");
                    }
                    ++count;
                    buffer.append(param);
                    ++n2;
                }
            }
            catch (ModelException modelException) {}
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static String getTypeSignature(IType field) {
        return ScriptElementLabels.getDefault().getElementLabel((IModelElement)field, 281474979069952L);
    }

    public static String getFieldSignature(IField field) {
        return ScriptElementLabels.getDefault().getElementLabel((IModelElement)field, 65536L);
    }
}

