/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ui.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class PluginImagesHelper {
    public static final String T_OBJ = "obj16";
    public static final String T_OVR = "ovr16";
    public static final String T_WIZBAN = "wizban";
    public static final String T_ELCL = "elcl16";
    public static final String T_DLCL = "dlcl16";
    public static final String T_ETOOL = "etool16";
    private Bundle bundle;
    private IPath iconsPath;
    private ImageRegistry imageRegistry;
    private HashMap avoidSWTErrorMap;

    public PluginImagesHelper(Bundle bundle, IPath iconsPath) {
        this.bundle = bundle;
        this.iconsPath = iconsPath;
    }

    private void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = this.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = this.create("e" + type, relPath);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = this.iconsPath.append(prefix).append(name);
        return PluginImagesHelper.createImageDescriptor(this.bundle, path, useMissingImageDescriptor);
    }

    private ImageDescriptor create(String prefix, String name) {
        return this.create(prefix, name, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public ImageDescriptor createUnManaged(String prefix, String name) {
        return this.create(prefix, name, true);
    }

    public ImageDescriptor createManaged(String prefix, String name, String key) {
        try {
            ImageDescriptor result = this.create(prefix, name, true);
            if (this.avoidSWTErrorMap == null) {
                this.avoidSWTErrorMap = new HashMap();
            }
            this.avoidSWTErrorMap.put(key, result);
            if (this.imageRegistry != null) {
                throw new Error(Messages.PluginImagesHelper_imageRegistryAlreadyDefined);
            }
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = new ImageRegistry();
            for (String key : this.avoidSWTErrorMap.keySet()) {
                this.imageRegistry.put(key, (ImageDescriptor)this.avoidSWTErrorMap.get(key));
            }
            this.avoidSWTErrorMap = null;
        }
        return this.imageRegistry;
    }

    public Image get(String key) {
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getDescriptor(String key) {
        if (this.imageRegistry == null) {
            return (ImageDescriptor)this.avoidSWTErrorMap.get(key);
        }
        return this.getImageRegistry().getDescriptor(key);
    }

    public void setToolImageDescriptors(IAction action, String iconName) {
        this.setImageDescriptors(action, "tool16", iconName);
    }

    public void setLocalImageDescriptors(IAction action, String iconName) {
        this.setImageDescriptors(action, "lcl16", iconName);
    }
}

